/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.security.oauth2;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.Headers;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.interceptor.RequestInterceptor;
import org.wso2.msf4j.security.MSF4JSecurityException;
import org.wso2.msf4j.security.SecurityErrorCode;
import org.wso2.msf4j.util.SystemVariableUtil;

public class OAuth2SecurityInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OAuth2SecurityInterceptor.class);
    private static final String AUTHORIZATION_HTTP_HEADER = "Authorization";
    private static final String AUTH_TYPE_OAUTH2 = "OAuth2";
    private static final String BEARER_PREFIX = "bearer";
    private static final String AUTH_SERVER_URL_KEY = "AUTH_SERVER_URL";
    private static final String AUTH_SERVER_URL = SystemVariableUtil.getValue("AUTH_SERVER_URL", null);
    private static final String TRUST_STORE = "TRUST_STORE";
    private static final String TRUST_STORE_PASSWORD = "TRUST_STORE_PASSWORD";

    @Override
    public boolean interceptRequest(Request request, Response response) throws Exception {
        try {
            Headers headers = request.getHeaders();
            if (headers != null && headers.contains(AUTHORIZATION_HTTP_HEADER)) {
                String authHeader = headers.get(AUTHORIZATION_HTTP_HEADER);
                return this.validateToken(authHeader);
            }
            throw new MSF4JSecurityException(SecurityErrorCode.AUTHENTICATION_FAILURE, "Missing Authorization header is the request.`");
        }
        catch (MSF4JSecurityException e) {
            SecurityErrorCode errorCode = e.getErrorCode();
            log.error(e.getMessage() + " Requested Path: " + request.getUri());
            this.handleSecurityError(errorCode, response);
            return false;
        }
    }

    private boolean validateToken(String authHeader) throws MSF4JSecurityException {
        String accessToken = this.extractAccessToken(authHeader);
        String responseStr = this.getValidatedTokenResponse(accessToken);
        Map<String, String> responseData = this.getResponseDataMap(responseStr);
        if (!Boolean.parseBoolean(responseData.get("active"))) {
            throw new MSF4JSecurityException(SecurityErrorCode.AUTHENTICATION_FAILURE, "Invalid Access token.");
        }
        return true;
    }

    private String extractAccessToken(String authHeader) throws MSF4JSecurityException {
        String[] authHeaderParts;
        if ((authHeader = authHeader.trim()).toLowerCase(Locale.US).startsWith(BEARER_PREFIX) && (authHeaderParts = authHeader.split(" ")).length == 2) {
            return authHeaderParts[1];
        }
        throw new MSF4JSecurityException(SecurityErrorCode.INVALID_AUTHORIZATION_HEADER, "Invalid Authorization header: " + authHeader);
    }

    private String getValidatedTokenResponse(String accessToken) throws MSF4JSecurityException {
        try {
            URL url = new URL(AUTH_SERVER_URL);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setDoOutput(true);
            urlConn.setRequestMethod("POST");
            urlConn.getOutputStream().write(("token=" + accessToken + "&token_type_hint=" + BEARER_PREFIX).getBytes(Charsets.UTF_8));
            return new String(IOUtils.toByteArray((InputStream)urlConn.getInputStream()), Charsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Error invoking Authorization Server", (Throwable)e);
            throw new MSF4JSecurityException(SecurityErrorCode.GENERIC_ERROR, "Error invoking Authorization Server", e);
        }
    }

    private Map<String, String> getResponseDataMap(String responseStr) {
        Gson gson = new Gson();
        Type typeOfMapOfStrings = new ExtendedTypeToken<Map<String, String>>(){}.getType();
        return (Map)gson.fromJson(responseStr, typeOfMapOfStrings);
    }

    private void handleSecurityError(SecurityErrorCode errorCode, Response responder) throws Exception {
        if (errorCode == SecurityErrorCode.AUTHENTICATION_FAILURE || errorCode == SecurityErrorCode.INVALID_AUTHORIZATION_HEADER) {
            responder.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            responder.setHeader("WWW-Authenticate", AUTH_TYPE_OAUTH2);
        } else if (errorCode == SecurityErrorCode.AUTHORIZATION_FAILURE) {
            responder.setStatus(Response.Status.FORBIDDEN.getStatusCode());
        } else {
            responder.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    static {
        if (AUTH_SERVER_URL == null) {
            throw new RuntimeException("AUTH_SERVER_URL is not specified.");
        }
        String trustStore = SystemVariableUtil.getValue(TRUST_STORE, null);
        String trustStorePassword = SystemVariableUtil.getValue(TRUST_STORE_PASSWORD, null);
        if (trustStore != null && !trustStore.isEmpty() && trustStorePassword != null && !trustStorePassword.isEmpty()) {
            System.setProperty("javax.net.ssl.trustStore", trustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
    }

    private static class ExtendedTypeToken<T>
    extends TypeToken {
        private ExtendedTypeToken() {
        }
    }
}

