/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.httpmonitoring.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.msf4j.analytics.httpmonitoring.config.model.HTTPMonitoringConfig;
import org.wso2.msf4j.analytics.internal.DataHolder;

public final class HTTPMonitoringConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HTTPMonitoringConfigBuilder.class);
    private static final String DEPLOYMENT_YAML_SYS_PROPERTY = "msf4j.conf";
    private static final String DEPLOYMENT_YAML_FILE = "deployment.yaml";

    public static HTTPMonitoringConfig build() {
        HTTPMonitoringConfig configurationObject;
        ConfigProvider configProvider = DataHolder.getInstance().getConfigProvider();
        if (configProvider == null) {
            if (DataHolder.getInstance().getBundleContext() != null) {
                throw new RuntimeException("Failed to populate HTTPMonitoringConfig Configuration. Config Provider is Null.");
            }
            String deploymentYamlPath = System.getProperty(DEPLOYMENT_YAML_SYS_PROPERTY);
            if (deploymentYamlPath == null || deploymentYamlPath.isEmpty()) {
                logger.info("System property 'msf4j.conf' is not set. Default deployment.yaml file will be used.");
                deploymentYamlPath = HTTPMonitoringConfig.class.getResource("/deployment.yaml").getPath();
            } else if (!Files.exists(Paths.get(deploymentYamlPath, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("Couldn't find " + deploymentYamlPath);
            }
            try {
                configProvider = ConfigProviderFactory.getConfigProvider((Path)Paths.get(deploymentYamlPath, new String[0]), null);
                DataHolder.getInstance().setConfigProvider(configProvider);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error loading deployment.yaml Configuration", e);
            }
        }
        try {
            configurationObject = (HTTPMonitoringConfig)DataHolder.getInstance().getConfigProvider().getConfigurationObject(HTTPMonitoringConfig.class);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Error while loading " + HTTPMonitoringConfig.class.getName() + " from config provider", e);
        }
        return configurationObject;
    }
}

