/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.websocket;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

public class EndpointDispatcher {
    public boolean validateEndpointUri(Object websocketEndpoint) {
        if (websocketEndpoint != null) {
            return websocketEndpoint.getClass().isAnnotationPresent(ServerEndpoint.class);
        }
        return false;
    }

    public String getUri(Object webSocketEndpoint) {
        return webSocketEndpoint.getClass().getAnnotation(ServerEndpoint.class).value();
    }

    public Optional<Method> getOnOpenMethod(Object webSocketEndpoint) {
        Method[] methods = webSocketEndpoint.getClass().getMethods();
        Method returnMethod = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(OnOpen.class)) continue;
            returnMethod = method;
            break;
        }
        return Optional.ofNullable(returnMethod);
    }

    public Optional<Method> getOnCloseMethod(Object webSocketEndpoint) {
        Method[] methods = webSocketEndpoint.getClass().getMethods();
        Method returnMethod = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(OnClose.class)) continue;
            returnMethod = method;
            break;
        }
        return Optional.ofNullable(returnMethod);
    }

    public Optional<Method> getOnErrorMethod(Object webSocketEndpoint) {
        Method[] methods = webSocketEndpoint.getClass().getMethods();
        Method returnMethod = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(OnError.class)) continue;
            returnMethod = method;
        }
        return Optional.ofNullable(returnMethod);
    }

    public Optional<Method> getOnStringMessageMethod(Object webSocketEndpoint) {
        Method[] methods = webSocketEndpoint.getClass().getMethods();
        Method returnMethod = null;
        for (Method method : methods) {
            Parameter[] parameters;
            if (!method.isAnnotationPresent(OnMessage.class)) continue;
            for (Parameter parameter : parameters = method.getParameters()) {
                if (parameter.isAnnotationPresent(PathParam.class) || parameter.getType() != String.class) continue;
                returnMethod = method;
            }
        }
        return Optional.ofNullable(returnMethod);
    }

    public Optional<Method> getOnBinaryMessageMethod(Object webSocketEndpoint) {
        Method[] methods = webSocketEndpoint.getClass().getMethods();
        Method returnMethod = null;
        for (Method method : methods) {
            Class<?>[] paraTypes;
            List<Class<?>> paraList;
            if (!method.isAnnotationPresent(OnMessage.class) || !(paraList = Arrays.asList(paraTypes = method.getParameterTypes())).contains(byte[].class) && !paraList.contains(ByteBuffer.class)) continue;
            returnMethod = method;
        }
        return Optional.ofNullable(returnMethod);
    }

    public Optional<Method> getOnPongMessageMethod(Object webSocketEndpoint) {
        Method[] methods = webSocketEndpoint.getClass().getMethods();
        Method returnMethod = null;
        for (Method method : methods) {
            Class<?>[] paraTypes;
            List<Class<?>> paraList;
            if (!method.isAnnotationPresent(OnMessage.class) || !(paraList = Arrays.asList(paraTypes = method.getParameterTypes())).contains(PongMessage.class)) continue;
            returnMethod = method;
        }
        return Optional.ofNullable(returnMethod);
    }
}

