/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.HttpStreamHandler;
import org.wso2.msf4j.HttpStreamer;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.interceptor.InterceptorExecutor;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.HttpResourceModelProcessor;
import org.wso2.msf4j.internal.router.ImmutablePair;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.internal.router.SubresourceKey;
import org.wso2.msf4j.internal.router.Util;

public class HttpMethodInfo {
    private final Method method;
    private final Object handler;
    private final Object[] args;
    private MultivaluedMap<String, Object> formParameters = null;
    private Response responder;
    private HttpStreamHandler httpStreamHandler;
    private static final Logger log = LoggerFactory.getLogger(HttpMethodInfo.class);
    private static final String DECLARING_CLASS_LIST_CONSTANT = "declaringClassList";
    private static final String RESOURCE_METHOD_LIST_CONSTANT = "resourceMethodList";

    public HttpMethodInfo(Method method, Object handler, Object[] args, MultivaluedMap<String, Object> formParameters, Response responder) {
        this.method = method;
        this.handler = handler;
        this.args = Arrays.copyOf(args, args.length);
        this.formParameters = formParameters;
        this.responder = responder;
    }

    public HttpMethodInfo(Method method, Object handler, Object[] args, MultivaluedMap<String, Object> formParameters, Response responder, HttpStreamer httpStreamer) throws HandlerException {
        this(method, handler, args, formParameters, responder);
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Resource method should be void if it accepts chunked requests");
        }
        try {
            method.invoke(handler, args);
        }
        catch (InvocationTargetException e) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Resource method invocation failed", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Resource method invocation access failed", e);
        }
        this.httpStreamHandler = httpStreamer.getHttpStreamHandler();
        if (this.httpStreamHandler == null) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Streaming unsupported");
        }
        this.httpStreamHandler.init(this.responder);
    }

    public void invoke(PatternPathRouter.RoutableDestination<HttpResourceModel> destination, Request request, HttpMethodInfo httpMethodInfo, MicroservicesRegistryImpl microservicesRegistry) throws Exception {
        request.setProperty(DECLARING_CLASS_LIST_CONSTANT, new ArrayList());
        request.setProperty(RESOURCE_METHOD_LIST_CONSTANT, new ArrayList());
        ImmutablePair<Boolean, Object> returnVal = this.invokeResource(destination, httpMethodInfo, request, microservicesRegistry, false);
        if (returnVal.getFirst().booleanValue() && InterceptorExecutor.executeMethodResponseInterceptorsForMethods((Request)request, (Response)httpMethodInfo.responder, (List)((ArrayList)request.getProperty(RESOURCE_METHOD_LIST_CONSTANT))) && InterceptorExecutor.executeClassResponseInterceptorsForClasses((Request)request, (Response)httpMethodInfo.responder, (List)((ArrayList)request.getProperty(DECLARING_CLASS_LIST_CONSTANT))) && InterceptorExecutor.executeGlobalResponseInterceptors((MicroservicesRegistryImpl)microservicesRegistry, (Request)request, (Response)httpMethodInfo.responder)) {
            this.responder.setEntity(returnVal.getSecond());
        }
        this.responder.send();
    }

    private ImmutablePair<Boolean, Object> invokeResource(PatternPathRouter.RoutableDestination<HttpResourceModel> destination, HttpMethodInfo httpMethodInfo, Request request, MicroservicesRegistryImpl microservicesRegistry, boolean isSubResource) throws Exception {
        Class<?> clazz = httpMethodInfo.method.getDeclaringClass();
        request.setProperty("method", (Object)httpMethodInfo.method);
        if (!isSubResource && !InterceptorExecutor.executeGlobalRequestInterceptors((MicroservicesRegistryImpl)microservicesRegistry, (Request)request, (Response)httpMethodInfo.responder)) {
            return ImmutablePair.of(false, new Object());
        }
        if (InterceptorExecutor.executeClassLevelRequestInterceptors((Request)request, (Response)httpMethodInfo.responder, clazz) && InterceptorExecutor.executeMethodLevelRequestInterceptors((Request)request, (Response)httpMethodInfo.responder, (Method)httpMethodInfo.method)) {
            Object returnedValue = httpMethodInfo.method.invoke(httpMethodInfo.handler, httpMethodInfo.args);
            ((ArrayList)request.getProperty(DECLARING_CLASS_LIST_CONSTANT)).add(0, clazz);
            ((ArrayList)request.getProperty(RESOURCE_METHOD_LIST_CONSTANT)).add(0, httpMethodInfo.method);
            return httpMethodInfo.invokeSubResource(request, destination, returnedValue, microservicesRegistry);
        }
        return ImmutablePair.of(false, new Object());
    }

    private ImmutablePair<Boolean, Object> invokeSubResource(Request request, PatternPathRouter.RoutableDestination<HttpResourceModel> destination, Object returnVal, MicroservicesRegistryImpl microservicesRegistry) throws Exception {
        if (destination.getDestination().isSubResourceLocator()) {
            Pattern pattern;
            Matcher matcher;
            HttpResourceModel resourceModel;
            String requestPath = request.getUri();
            if (requestPath.endsWith("/")) {
                requestPath = requestPath.substring(0, requestPath.length() - 1);
            }
            if (requestPath.contains("?")) {
                requestPath = requestPath.substring(0, requestPath.indexOf("?"));
            }
            if (!destination.getDestination().isSubResourceScanned()) {
                for (Method method : returnVal.getClass().getMethods()) {
                    SubresourceKey subResKey;
                    HttpResourceModel resourceModel2;
                    String absolutePath;
                    String relativePath;
                    if (Modifier.isPublic(method.getModifiers()) && Util.isHttpMethodAvailable(method)) {
                        relativePath = "";
                        if (method.getAnnotation(Path.class) != null) {
                            relativePath = method.getAnnotation(Path.class).value();
                        }
                        if (relativePath.startsWith("/")) {
                            relativePath = relativePath.substring(1);
                        }
                        absolutePath = relativePath.isEmpty() ? destination.getDestination().getPath() : String.format("%s/%s", destination.getDestination().getPath(), relativePath);
                        resourceModel2 = new HttpResourceModel(absolutePath, method, returnVal, false);
                        resourceModel2.setParent(destination.getDestination());
                        subResKey = new SubresourceKey(absolutePath, method.getDeclaringClass(), resourceModel2.getHttpMethod());
                        destination.getDestination().addSubResources(subResKey, resourceModel2);
                        continue;
                    }
                    if (!Modifier.isPublic(method.getModifiers()) || method.getAnnotation(Path.class) == null) continue;
                    relativePath = method.getAnnotation(Path.class).value();
                    if (relativePath.startsWith("/")) {
                        relativePath = relativePath.substring(1);
                    }
                    absolutePath = relativePath.isEmpty() ? destination.getDestination().getPath() : String.format("%s/%s", destination.getDestination().getPath(), relativePath);
                    resourceModel2 = new HttpResourceModel(absolutePath, method, returnVal, true);
                    resourceModel2.setParent(destination.getDestination());
                    subResKey = new SubresourceKey(absolutePath, method.getDeclaringClass(), Collections.emptySet());
                    destination.getDestination().addSubResources(subResKey, resourceModel2);
                }
                destination.getDestination().setSubResourceScanned(true);
            }
            String finalRequestPath = requestPath;
            List entries = destination.getDestination().getSubResources().entrySet().stream().filter(e -> ((HttpResourceModel)e.getValue()).getHttpMethod().contains(request.getHttpMethod()) && finalRequestPath.matches(((SubresourceKey)e.getKey()).getPath().replaceAll("\\{(.*?)\\}", "([^/]+?)")) && returnVal.getClass().equals(((SubresourceKey)e.getKey()).getTypedClass())).collect(Collectors.toList());
            Optional<Map.Entry> entry = entries.stream().filter(entryPair -> ((HttpResourceModel)entryPair.getValue()).matchConsumeMediaType(request.getContentType()) && ((HttpResourceModel)entryPair.getValue()).matchProduceMediaType(request.getAcceptTypes())).findFirst();
            if (entry.isPresent()) {
                resourceModel = (HttpResourceModel)entry.get().getValue();
            } else {
                String finalRequestPath1 = requestPath;
                entries = destination.getDestination().getSubResources().entrySet().stream().filter(e -> finalRequestPath1.matches(((SubresourceKey)e.getKey()).getPath().replaceAll("\\{(.*?)\\}", "([^/]+?)").concat(".*")) && ((HttpResourceModel)e.getValue()).isSubResourceLocator() && returnVal.getClass().equals(((SubresourceKey)e.getKey()).getTypedClass())).collect(Collectors.toList());
                entry = entries.stream().filter(entryPair -> ((HttpResourceModel)entryPair.getValue()).matchConsumeMediaType(request.getContentType()) && ((HttpResourceModel)entryPair.getValue()).matchProduceMediaType(request.getAcceptTypes())).findFirst();
                if (entry.isPresent()) {
                    resourceModel = (HttpResourceModel)entry.get().getValue();
                } else {
                    throw new HandlerException(Response.Status.NOT_FOUND, String.format("Problem accessing: %s. Reason: Not Found", requestPath));
                }
            }
            Path declaredAnnotation = resourceModel.getMethod().getDeclaredAnnotation(Path.class);
            String[] parts = declaredAnnotation.value().split("/");
            StringBuilder sb = new StringBuilder();
            ArrayList<String> groupNames = new ArrayList<String>();
            for (String part : parts) {
                Matcher groupMatcher = Pattern.compile("\\{(.*?)\\}").matcher(part);
                if (groupMatcher.matches()) {
                    groupNames.add(Util.stripBraces(part));
                    sb.append("([^/]+)");
                } else if (Util.WILD_CARD_PATTERN.matcher(part).matches()) {
                    sb.append(".*?");
                } else {
                    sb.append(part);
                }
                sb.append("/");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            HashMap<String, String> groupNameValues = new HashMap<String, String>();
            destination.getGroupNameValues().entrySet().forEach(e -> {
                String cfr_ignored_0 = (String)groupNameValues.put((String)e.getKey(), (String)e.getValue());
            });
            String[] paths = requestPath.split(destination.getDestination().getPath().replaceAll("\\{(.*?)\\}", "([^/]+)"));
            String subResPath = "/";
            if (paths.length != 0) {
                subResPath = paths[1];
            }
            if ((matcher = (pattern = Pattern.compile(sb.toString() + ".*")).matcher(subResPath)).matches()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    groupNameValues.putIfAbsent((String)groupNames.get(i - 1), matcher.group(i));
                }
            }
            HttpResourceModelProcessor httpSubResourceModelProcessor = new HttpResourceModelProcessor(resourceModel);
            httpSubResourceModelProcessor.setFormParameters(this.formParameters);
            this.responder.setMediaType(Util.getResponseType(request.getAcceptTypes(), resourceModel.getProducesMediaTypes()));
            HttpMethodInfo httpMethodInfo = httpSubResourceModelProcessor.buildHttpMethodInfo(request, this.responder, groupNameValues);
            PatternPathRouter.RoutableDestination<HttpResourceModel> newDestination = new PatternPathRouter.RoutableDestination<HttpResourceModel>(resourceModel, groupNameValues);
            return this.invokeResource(newDestination, httpMethodInfo, request, microservicesRegistry, true);
        }
        return ImmutablePair.of(true, returnVal);
    }

    public void chunk(ByteBuffer chunk) throws Exception {
        try {
            this.httpStreamHandler.chunk(chunk);
        }
        catch (Throwable e) {
            log.error("Exception while invoking streaming handlers", e);
            this.httpStreamHandler.error(e);
            throw e;
        }
    }

    public void end(boolean isResponseInterceptorsSuccessful) throws Exception {
        try {
            this.httpStreamHandler.end();
        }
        catch (Throwable e) {
            log.error("Exception while invoking streaming handlers", e);
            log.error("Response interceptor execute is successful : " + isResponseInterceptorsSuccessful, e);
            this.httpStreamHandler.error(e);
            throw e;
        }
    }

    public boolean isStreamingSupported() {
        return this.httpStreamHandler != null;
    }
}

