/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.client;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.analytics.common.tracing.TraceEvent;
import org.wso2.msf4j.analytics.common.tracing.TracingEventTracker;
import org.wso2.msf4j.analytics.common.tracing.TracingUtil;
import org.wso2.msf4j.client.ModelUtils;

class FeignTracingClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(FeignTracingClient.class);
    private final String instanceId;
    private final String instanceName;
    private final String dasUrl;
    private final Client clientDelegate;

    public FeignTracingClient(Client client, String instanceName) {
        this(client, instanceName, "http://localhost:9763/endpoints/msf4jtracereceiver");
    }

    public FeignTracingClient(Client client, String instanceName, String dasReceiverUrl) {
        this.instanceName = instanceName;
        this.dasUrl = dasReceiverUrl;
        this.instanceId = TracingUtil.generateUniqueId();
        this.clientDelegate = client;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        TraceEvent clientStartTraceEvent = this.generateClientStartTraceEvent(request);
        Request traceableRequest = this.tracePreRequest(request, clientStartTraceEvent);
        Response response = this.clientDelegate.execute(traceableRequest, options);
        this.tracePostRequest(response, clientStartTraceEvent);
        return response;
    }

    private TraceEvent generateClientStartTraceEvent(Request request) {
        String clientTraceId;
        String traceOriginId;
        long time = new Date().getTime();
        String traceParentId = null;
        TraceEvent parentEvent = TracingEventTracker.getTraceEvent();
        if (parentEvent == null) {
            clientTraceId = traceOriginId = TracingUtil.generateUniqueId();
        } else {
            traceOriginId = parentEvent.getOriginId();
            clientTraceId = TracingUtil.generateUniqueId();
            traceParentId = parentEvent.getTraceId();
        }
        TraceEvent clientStartTraceEvent = new TraceEvent("CTS", clientTraceId, traceOriginId, time);
        clientStartTraceEvent.setInstanceId(this.instanceId);
        clientStartTraceEvent.setInstanceName(this.instanceName);
        clientStartTraceEvent.setParentId(traceParentId);
        clientStartTraceEvent.setHttpMethod(request.method());
        clientStartTraceEvent.setUrl(request.url());
        if (log.isDebugEnabled()) {
            log.debug("clientStartTraceEvent: " + ModelUtils.toString(clientStartTraceEvent));
        }
        return clientStartTraceEvent;
    }

    private Request tracePreRequest(Request request, TraceEvent traceEvent) {
        HashMap<String, List<String>> traceHeaders = new HashMap<String, List<String>>();
        traceHeaders.putAll(request.headers());
        traceHeaders.put("X-msf4j-trace-id", Collections.singletonList(traceEvent.getTraceId()));
        traceHeaders.put("X-msf4j-trace-origin-id", Collections.singletonList(traceEvent.getOriginId()));
        TracingUtil.pushToDAS((TraceEvent)traceEvent, (String)this.dasUrl);
        return Request.create((String)request.method(), (String)request.url(), traceHeaders, (byte[])request.body(), (Charset)request.charset());
    }

    private void tracePostRequest(Response response, TraceEvent traceEvent) {
        long time = new Date().getTime();
        if (traceEvent != null) {
            TraceEvent clientEndTraceEvent = new TraceEvent("CTE", traceEvent.getTraceId(), traceEvent.getOriginId(), time);
            clientEndTraceEvent.setStatusCode(response.status());
            if (log.isDebugEnabled()) {
                log.debug("ClientEndTraceEvent: " + ModelUtils.toString(clientEndTraceEvent));
            }
            TracingUtil.pushToDAS((TraceEvent)clientEndTraceEvent, (String)this.dasUrl);
        }
    }
}

