/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.client;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.EmptySpanCollectorMetricsHandler;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.HttpClientRequest;
import com.github.kristofa.brave.http.HttpClientRequestAdapter;
import com.github.kristofa.brave.http.HttpClientResponseAdapter;
import com.github.kristofa.brave.http.HttpResponse;
import com.github.kristofa.brave.http.HttpSpanCollector;
import com.github.kristofa.brave.http.SpanNameProvider;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.analytics.zipkintracing.TraceableHttpClientRequest;
import org.wso2.msf4j.analytics.zipkintracing.TraceableHttpClientResponse;
import org.wso2.msf4j.client.FeignTracingClient;

public class FeginZipkinTracingClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(FeignTracingClient.class);
    private final Client clientDelegate;
    private final ClientRequestInterceptor requestInterceptor;
    private final ClientResponseInterceptor responseInterceptor;

    public FeginZipkinTracingClient(Client client, String instanceName) {
        this(client, instanceName, "http://0.0.0.0:9411");
    }

    public FeginZipkinTracingClient(Client client, String instanceName, String zipkinUrl) {
        this.clientDelegate = client;
        Brave.Builder builder = new Brave.Builder(instanceName);
        builder.spanCollector((SpanCollector)HttpSpanCollector.create((String)zipkinUrl, (SpanCollectorMetricsHandler)new EmptySpanCollectorMetricsHandler()));
        Brave brave = builder.build();
        this.requestInterceptor = brave.clientRequestInterceptor();
        this.responseInterceptor = brave.clientResponseInterceptor();
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HashMap traceHeaders = new HashMap();
        traceHeaders.putAll(request.headers());
        Request wrappedRequest = Request.create((String)request.method(), (String)request.url(), traceHeaders, (byte[])request.body(), (Charset)request.charset());
        TraceableHttpClientRequest httpClientRequest = new TraceableHttpClientRequest(wrappedRequest);
        HttpClientRequestAdapter adapter = new HttpClientRequestAdapter((HttpClientRequest)httpClientRequest, (SpanNameProvider)new DefaultSpanNameProvider());
        this.requestInterceptor.handle((ClientRequestAdapter)adapter);
        Response response = this.clientDelegate.execute(wrappedRequest, options);
        TraceableHttpClientResponse httpResponse = new TraceableHttpClientResponse(response);
        HttpClientResponseAdapter responseAdapter = new HttpClientResponseAdapter((HttpResponse)httpResponse);
        this.responseInterceptor.handle((ClientResponseAdapter)responseAdapter);
        return response;
    }
}

