/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.client;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public final class ApacheHttpClient
implements Client {
    private static final String ACCEPT_HEADER_NAME = "Accept";
    private final ThreadLocal<HttpContext> httpContextThreadLocal = new ThreadLocal();
    private final HttpClient client;

    public ApacheHttpClient() {
        this((HttpClient)HttpClientBuilder.create().build());
    }

    public ApacheHttpClient(HttpClient client) {
        this.client = client;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HttpUriRequest httpUriRequest;
        HttpContext httpContext = this.httpContextThreadLocal.get();
        if (httpContext == null) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            httpContext = new BasicHttpContext();
            httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
            this.httpContextThreadLocal.set(httpContext);
        }
        try {
            httpUriRequest = this.toHttpUriRequest(request, options);
        }
        catch (URISyntaxException e) {
            throw new IOException("URL '" + request.url() + "' couldn't be parsed into a URI", e);
        }
        HttpResponse httpResponse = this.client.execute(httpUriRequest, httpContext);
        return this.toFeignResponse(httpResponse).toBuilder().request(request).build();
    }

    HttpUriRequest toHttpUriRequest(Request request, Request.Options options) throws UnsupportedEncodingException, MalformedURLException, URISyntaxException {
        RequestBuilder requestBuilder = RequestBuilder.create((String)request.method());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(options.connectTimeoutMillis()).setSocketTimeout(options.readTimeoutMillis()).build();
        requestBuilder.setConfig(requestConfig);
        URI uri = new URIBuilder(request.url()).build();
        requestBuilder.setUri(uri.getScheme() + "://" + uri.getAuthority() + uri.getRawPath());
        List queryParams = URLEncodedUtils.parse((URI)uri, (String)requestBuilder.getCharset().name());
        for (Object queryParam : queryParams) {
            requestBuilder.addParameter((NameValuePair)queryParam);
        }
        boolean hasAcceptHeader = false;
        for (Map.Entry entry : request.headers().entrySet()) {
            String headerName = (String)entry.getKey();
            if (headerName.equalsIgnoreCase(ACCEPT_HEADER_NAME)) {
                hasAcceptHeader = true;
            }
            if (headerName.equalsIgnoreCase("Content-Length")) continue;
            for (String headerValue : (Collection)entry.getValue()) {
                requestBuilder.addHeader(headerName, headerValue);
            }
        }
        if (!hasAcceptHeader) {
            requestBuilder.addHeader(ACCEPT_HEADER_NAME, "*/*");
        }
        if (request.body() != null) {
            ByteArrayEntity entity = null;
            if (request.charset() != null) {
                ContentType contentType = this.getContentType(request);
                String content = new String(request.body(), request.charset());
                entity = new StringEntity(content, contentType);
            } else {
                entity = new ByteArrayEntity(request.body());
            }
            requestBuilder.setEntity((HttpEntity)entity);
        }
        return requestBuilder.build();
    }

    private ContentType getContentType(Request request) {
        ContentType contentType = ContentType.DEFAULT_TEXT;
        for (Map.Entry entry : request.headers().entrySet()) {
            Collection values;
            if (!((String)entry.getKey()).equalsIgnoreCase("Content-Type") || (values = (Collection)entry.getValue()) == null || values.isEmpty()) continue;
            contentType = ContentType.create((String)((String)((Collection)entry.getValue()).iterator().next()), (Charset)request.charset());
            break;
        }
        return contentType;
    }

    Response toFeignResponse(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        String reason = statusLine.getReasonPhrase();
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (Header header : httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            ArrayList<String> headerValues = (ArrayList<String>)headers.get(name);
            if (headerValues == null) {
                headerValues = new ArrayList<String>();
                headers.put(name, headerValues);
            }
            headerValues.add(value);
        }
        return Response.builder().status(statusCode).reason(reason).headers(headers).body(this.toFeignBody(httpResponse)).build();
    }

    Response.Body toFeignBody(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        return new HttpEntityResponseBody(entity);
    }

    private static class HttpEntityResponseBody
    implements Response.Body {
        final HttpEntity entity;

        HttpEntityResponseBody(HttpEntity entity) {
            this.entity = entity;
        }

        public Integer length() {
            return this.entity.getContentLength() >= 0L && this.entity.getContentLength() <= Integer.MAX_VALUE ? Integer.valueOf((int)this.entity.getContentLength()) : null;
        }

        public boolean isRepeatable() {
            return this.entity.isRepeatable();
        }

        public InputStream asInputStream() throws IOException {
            return this.entity.getContent();
        }

        public Reader asReader() throws IOException {
            return new InputStreamReader(this.asInputStream(), Util.UTF_8);
        }

        public void close() throws IOException {
            EntityUtils.consume((HttpEntity)this.entity);
        }
    }
}

