/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.services.jaxrs.musicsample;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.wso2.esb.integration.services.jaxrs.musicsample.MusicService;
import org.wso2.esb.integration.services.jaxrs.musicsample.bean.Music;
import org.wso2.esb.integration.services.jaxrs.musicsample.bean.Singer;

@Path(value="/music")
public class MusicRestService {
    @Inject
    private MusicService musicService;

    @GET
    @Path(value="/get")
    @Produces(value={"application/json"})
    public Music getMusicInJSON(@QueryParam(value="album") String albumName) {
        return this.musicService.getByAlbum(albumName);
    }

    @POST
    @Path(value="/post")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createMusicInJSONPOST(Music music) {
        this.musicService.setMusic(music);
        String result = "Album Added in POST : " + music;
        return Response.status((int)201).entity((Object)result).build();
    }

    @POST
    @Path(value="/postjson")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createMusicInJSONResponsePOST(Music music) {
        this.musicService.setMusic(music);
        return Response.status((int)201).entity((Object)music).build();
    }

    @PUT
    @Path(value="/put")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateMusicInJSONPUT(Music music) {
        Music musicOne = this.musicService.getByAlbum(music.getAlbum());
        musicOne.setSinger(music.getSinger());
        String result = "Album updated form PUT request: " + musicOne;
        return Response.status((int)201).entity((Object)result).build();
    }

    @POST
    @Path(value="/add_singer_details")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addSingerDetailsInJSONPOST(Singer singer) {
        this.musicService.setSinger(singer);
        String result = "Singer Added in POST : " + singer;
        return Response.status((int)201).entity((Object)result).build();
    }

    @GET
    @Path(value="/get_singer_details")
    @Produces(value={"application/json"})
    public Singer getSingerDetailsInJSON(@QueryParam(value="singer") String singerName) {
        return this.musicService.getBySinger(singerName);
    }
}

