/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.services.jaxrs.musicsample;

import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.wso2.esb.integration.services.jaxrs.musicsample.MusicConfig;

public class Server {
    private static final Log log = LogFactory.getLog(Server.class);

    public static void main(String[] args) throws Exception {
        File base = Server.createBaseDirectory();
        log.info((Object)("Using base folder: " + base.getAbsolutePath()));
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(8080);
        tomcat.setBaseDir(base.getAbsolutePath());
        Context context = tomcat.addContext("/", base.getAbsolutePath());
        Tomcat.addServlet((Context)context, (String)"CXFServlet", (Servlet)new CXFServlet());
        context.addServletMapping("/rest/*", "CXFServlet");
        context.addApplicationListener(ContextLoaderListener.class.getName());
        context.setLoader((Loader)new WebappLoader(Thread.currentThread().getContextClassLoader()));
        context.addParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        context.addParameter("contextConfigLocation", MusicConfig.class.getName());
        tomcat.start();
        tomcat.getServer().await();
    }

    private static File createBaseDirectory() throws IOException {
        File base = File.createTempFile("tmp-", "", new File("/home/dimuthu/Desktop/JMS"));
        if (!base.delete()) {
            throw new IOException("Cannot (re)create base folder: " + base.getAbsolutePath());
        }
        if (!base.mkdir()) {
            throw new IOException("Cannot create base folder: " + base.getAbsolutePath());
        }
        return base;
    }
}

