/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.operations.utils;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSClientHelper {
    public static final String ANDES_INITIAL_CONTEXT_FACTORY = "org.wso2.andes.jndi.PropertiesFileInitialContextFactory";
    public static final String QUEUE_CONNECTION_FACTORY = "andesQueueConnectionfactory";
    public static final String TOPIC_CONNECTION_FACTORY = "andesTopicConnectionfactory";

    public static InitialContext getInitialContextForQueue(String username, String password, String brokerHost, String port, String queueName) throws NamingException {
        Properties contextProperties = new Properties();
        contextProperties.put("java.naming.factory.initial", ANDES_INITIAL_CONTEXT_FACTORY);
        String connectionString = JMSClientHelper.getBrokerConnectionString(username, password, brokerHost, port);
        contextProperties.put("connectionfactory.andesQueueConnectionfactory", connectionString);
        contextProperties.put("queue." + queueName, queueName);
        return new InitialContext(contextProperties);
    }

    public static InitialContext getInitialContextForTopic(String username, String password, String brokerHost, String port, String topicName) throws NamingException {
        Properties contextProperties = new Properties();
        contextProperties.put("java.naming.factory.initial", ANDES_INITIAL_CONTEXT_FACTORY);
        String connectionString = JMSClientHelper.getBrokerConnectionString(username, password, brokerHost, port);
        contextProperties.put("connectionfactory.andesTopicConnectionfactory", connectionString);
        contextProperties.put("topic." + topicName, topicName);
        return new InitialContext(contextProperties);
    }

    private static String getBrokerConnectionString(String userName, String password, String brokerHost, String port) {
        return "amqp://" + userName + ":" + password + "@clientID/carbon?brokerlist='tcp://" + brokerHost + ":" + port + "'";
    }
}

