/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.operations.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.wso2.mb.integration.common.clients.AndesClient;

public class AndesClientUtils {
    private static Logger log = Logger.getLogger(AndesClientUtils.class);
    private static PrintWriter receivedMessagePrintWriter;
    private static PrintWriter statisticsPrintWriter;
    private static PrintWriter publishedMessagePrintWriter;

    public static void waitForMessagesAndShutdown(AndesClient client, long waitTimeTillMessageCounterChanges, long expectedMessageCount) throws JMSException {
        long previousMessageCount = 0L;
        long currentMessageCount = -1L;
        while (currentMessageCount != previousMessageCount) {
            try {
                TimeUnit.MILLISECONDS.sleep(waitTimeTillMessageCounterChanges);
            }
            catch (InterruptedException e) {
                log.error((Object)"Error waiting for receiving messages.", (Throwable)e);
            }
            previousMessageCount = currentMessageCount;
            currentMessageCount = client.getReceivedMessageCount();
        }
        log.info((Object)("Message count received by consumer : " + Long.toString(client.getReceivedMessageCount())));
        if (expectedMessageCount != currentMessageCount) {
            client.stopClient();
        }
        AndesClientUtils.flushPrintWriters();
    }

    public static void waitForMessagesAndShutdown(AndesClient client, long waitTimeTillMessageCounterChanges) throws JMSException {
        long previousMessageCount = 0L;
        long currentMessageCount = -1L;
        while (currentMessageCount != previousMessageCount) {
            try {
                TimeUnit.MILLISECONDS.sleep(waitTimeTillMessageCounterChanges);
            }
            catch (InterruptedException e) {
                log.error((Object)"Error waiting for receiving messages.", (Throwable)e);
            }
            previousMessageCount = currentMessageCount;
            currentMessageCount = client.getReceivedMessageCount();
        }
        log.info((Object)("Message count received by consumer : " + Long.toString(client.getReceivedMessageCount())));
        client.stopClient();
        AndesClientUtils.flushPrintWriters();
    }

    public static void shutdownClient(AndesClient client) throws JMSException {
        client.stopClient();
        AndesClientUtils.flushPrintWriters();
    }

    public static void sleepForInterval(long milliseconds) {
        if (0L < milliseconds) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void writeReceivedMessagesToFile(String content, String filePath) throws IOException {
        if (receivedMessagePrintWriter == null) {
            AndesClientUtils.initializeReceivedMessagesPrintWriter(filePath);
        }
        receivedMessagePrintWriter.println(content);
    }

    public static void writeStatisticsToFile(String content, String filePath) throws IOException {
        if (statisticsPrintWriter == null) {
            AndesClientUtils.initializeStatisticsPrintWriter(filePath);
        }
        statisticsPrintWriter.println(content);
    }

    public static void writePublishedMessagesToFile(String content, String filePath) throws IOException {
        if (publishedMessagePrintWriter == null) {
            AndesClientUtils.initializePublishedPrintWriter(filePath);
        }
        publishedMessagePrintWriter.println(content);
    }

    public static void initializeReceivedMessagesPrintWriter(String filePath) throws IOException {
        File writerFile;
        if (StringUtils.isNotEmpty((String)filePath) && ((writerFile = new File(filePath)).exists() || writerFile.createNewFile())) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filePath));
            receivedMessagePrintWriter = new PrintWriter(bufferedWriter);
        }
    }

    public static void initializeStatisticsPrintWriter(String filePath) throws IOException {
        File writerFile;
        if (StringUtils.isNotEmpty((String)filePath) && ((writerFile = new File(filePath)).exists() || writerFile.createNewFile())) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filePath));
            statisticsPrintWriter = new PrintWriter(bufferedWriter);
            statisticsPrintWriter.println("TIMESTAMP,CONSUMER_TPS,AVERAGE_LATENCY,,TIMESTAMP,PUBLISHER_TPS");
        }
    }

    public static void initializePublishedPrintWriter(String filePath) throws IOException {
        File writerFile;
        if (StringUtils.isNotEmpty((String)filePath) && ((writerFile = new File(filePath)).exists() || writerFile.createNewFile())) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filePath));
            publishedMessagePrintWriter = new PrintWriter(bufferedWriter);
        }
    }

    public static void flushPrintWriters() {
        if (null != receivedMessagePrintWriter) {
            receivedMessagePrintWriter.flush();
        }
        if (null != statisticsPrintWriter) {
            statisticsPrintWriter.flush();
        }
        if (null != publishedMessagePrintWriter) {
            publishedMessagePrintWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMockFile(String filePathToRead, String filePathToCreate, int sizeInKB) throws IOException {
        String fileContentToBeWritten = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePathToRead));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append('\n');
                line = br.readLine();
            }
            fileContentToBeWritten = sb.toString();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing buffered reader", (Throwable)e);
            }
        }
        AndesClientUtils.deleteRandomFile(filePathToCreate);
        try {
            File fileToCreate = new File(filePathToCreate);
            boolean createFileSuccess = fileToCreate.createNewFile();
            if (createFileSuccess) {
                log.info((Object)("Successfully created a file to append content for sending at " + filePathToCreate));
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filePathToCreate));
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            for (int count = 0; count < sizeInKB; ++count) {
                printWriter.append(fileContentToBeWritten);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException e) {
            log.error((Object)"Error. File to print received messages is not provided", (Throwable)e);
        }
    }

    public static String createRandomString(int sizeInBytes, int maxLineSize) {
        String messageContent = "";
        int noOfLines = (int)Math.ceil((long)sizeInBytes / (long)maxLineSize);
        int written = 0;
        int remaining = sizeInBytes;
        for (int i = 0; i < noOfLines; ++i) {
            if (remaining <= maxLineSize) {
                messageContent = messageContent + RandomStringUtils.randomAlphabetic((int)remaining);
                break;
            }
            messageContent = messageContent + RandomStringUtils.randomAlphanumeric((int)(maxLineSize - 1));
            messageContent = messageContent + "\n";
            written += maxLineSize;
            remaining -= maxLineSize;
        }
        return messageContent;
    }

    public static String createRandomString(int sizeInBytes) {
        return AndesClientUtils.createRandomString(sizeInBytes, sizeInBytes);
    }

    public static void deleteRandomFile(String filePathToDelete) throws IOException {
        File fileToDelete = new File(filePathToDelete);
        if (fileToDelete.exists() && !fileToDelete.delete()) {
            throw new IOException("Unable to delete random file, " + filePathToDelete);
        }
    }
}

