/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.operations.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mb.integration.common.clients.operations.utils.AndesClientUtils;

public class AndesClientOutputParser {
    private static Log log = LogFactory.getLog(AndesClientOutputParser.class);
    private Map<Long, Integer> mapOfReceivedMessages = new HashMap<Long, Integer>();
    private List<Long> messages = new ArrayList<Long>();
    private String filePath = "";

    public AndesClientOutputParser(String filePath) throws IOException {
        this.filePath = filePath;
        this.parseFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.filePath));){
            String line = br.readLine();
            while (line != null) {
                String tempSendMessageString = line.substring("Sending Message:{0} ThreadID:{1}".indexOf("Sending Message:") + "Sending Message:".length());
                long messageIdentifier = Long.valueOf(tempSendMessageString.substring(0, tempSendMessageString.indexOf(" ")).replace(",", ""));
                this.addMessage(messageIdentifier);
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error " + this.filePath + " the file containing received messages couldn't found"), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)("Error " + this.filePath + " the file cannot be read"), (Throwable)e);
            throw e;
        }
    }

    public Map<Long, Integer> getDuplicatedMessages() {
        HashMap<Long, Integer> messagesDuplicated = new HashMap<Long, Integer>();
        for (Long messageIdentifier : this.mapOfReceivedMessages.keySet()) {
            if (this.mapOfReceivedMessages.get(messageIdentifier) <= 1) continue;
            messagesDuplicated.put(messageIdentifier, this.mapOfReceivedMessages.get(messageIdentifier));
        }
        return messagesDuplicated;
    }

    public boolean checkIfMessagesAreInOrder() {
        boolean result = true;
        for (int count = 0; count < this.messages.size(); ++count) {
            if (this.messages.get(count) == (long)count) continue;
            result = false;
            log.warn((Object)("Message order is broken at message " + this.messages.get(count)));
            break;
        }
        return result;
    }

    public void printMissingMessages(int numberOfSentMessages) {
        log.info((Object)"Printing Missing Messages");
        for (long count = 0L; count < (long)numberOfSentMessages; ++count) {
            if (this.mapOfReceivedMessages.get(count) != null) continue;
            log.info((Object)("Missing message id:" + count + 1 + "\n"));
        }
    }

    public void printDuplicateMessages() {
        log.info((Object)"Printing Duplicated Messages");
        log.info(this.getDuplicatedMessages());
    }

    public void printMessagesMap() {
        log.info((Object)"Printing Received Messages");
        log.info(this.mapOfReceivedMessages);
    }

    private void addMessage(Long messageIdentifier) {
        if (this.mapOfReceivedMessages.get(messageIdentifier) == null) {
            this.mapOfReceivedMessages.put(messageIdentifier, 1);
        } else {
            int currentCount = this.mapOfReceivedMessages.get(messageIdentifier);
            this.mapOfReceivedMessages.put(messageIdentifier, currentCount + 1);
        }
        this.messages.add(messageIdentifier);
    }

    public void printMessagesSorted() {
        log.info((Object)"Printing Sorted Messages");
        ArrayList<Long> cloneOfMessages = new ArrayList<Long>();
        cloneOfMessages.addAll(this.messages);
        Collections.sort(cloneOfMessages);
        log.info(cloneOfMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transactedOperations(long operationOccurredIndex) throws FileNotFoundException {
        boolean result = false;
        int count = 0;
        long firstMessageIdentifier = 0L;
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.filePath));
            try {
                String line = br.readLine();
                while (line != null) {
                    String tempSendMessageString = line.substring("Sending Message:{0} ThreadID:{1}".indexOf("Sending Message:") + "Sending Message:".length());
                    long messageIdentifier = Long.parseLong(tempSendMessageString.substring(0, tempSendMessageString.indexOf(" ")));
                    if (count == 0) {
                        firstMessageIdentifier = messageIdentifier;
                    }
                    if ((long)count == operationOccurredIndex && messageIdentifier == firstMessageIdentifier) {
                        result = true;
                    }
                    line = br.readLine();
                    ++count;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while parsing the file containing received messages", (Throwable)e);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the file containing received messages", (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error " + this.filePath + " the file containing received messages couldn't found"), (Throwable)e);
            throw e;
        }
        AndesClientUtils.flushPrintWriters();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfTransactedRollbackPreservesOrder(long messagesPerRollback) throws FileNotFoundException {
        boolean result = true;
        int count = 0;
        int rollbackBatchIteration = 1;
        boolean isFirstMessageBatch = true;
        HashMap<Integer, Long> firstMessageBatch = new HashMap<Integer, Long>();
        try (LineIterator iterator = null;){
            iterator = FileUtils.lineIterator((File)new File(this.filePath));
            String line = iterator.nextLine();
            while (iterator.hasNext()) {
                Long messageIdentifier = this.getMessageIdentifier(line);
                if (firstMessageBatch.containsValue(messageIdentifier)) {
                    isFirstMessageBatch = false;
                    if ((long)count != messagesPerRollback * (long)rollbackBatchIteration) {
                        log.error((Object)("failed to check if rollback messages are received in order to due to first duplicated message count " + count + " not equal to messages per each rollback." + messagesPerRollback + "."));
                        result = false;
                    }
                    ++rollbackBatchIteration;
                }
                if (!isFirstMessageBatch) {
                    int i = 0;
                    while ((long)i < messagesPerRollback) {
                        messageIdentifier = this.getMessageIdentifier(line);
                        if (null != firstMessageBatch.get(i) && !((Long)firstMessageBatch.get(i)).equals(messageIdentifier)) {
                            result = false;
                            log.error((Object)("Error in line :" + line + ".Rollback operation failed to keep message order."));
                        }
                        if (iterator.hasNext()) {
                            line = iterator.nextLine();
                            ++count;
                        }
                        ++i;
                    }
                    continue;
                }
                if (!isFirstMessageBatch) continue;
                firstMessageBatch.put(count, messageIdentifier);
                line = iterator.nextLine();
                ++count;
            }
        }
        AndesClientUtils.flushPrintWriters();
        return result;
    }

    private Long getMessageIdentifier(String line) {
        String tempSendMessageString = line.substring("Sending Message:{0} ThreadID:{1}".indexOf("Sending Message:") + "Sending Message:".length());
        Long messageIdentifier = Long.parseLong(tempSendMessageString.substring(0, tempSendMessageString.indexOf(" ")));
        return messageIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberDuplicatedMessages() {
        long duplicateCount = 0L;
        ArrayList<Long> messagesDuplicated = new ArrayList<Long>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.filePath));
            try {
                String line = br.readLine();
                while (line != null) {
                    String tempSendMessageString = line.substring("Sending Message:{0} ThreadID:{1}".indexOf("Sending Message:") + "Sending Message:".length());
                    long messageIdentifier = Long.parseLong(tempSendMessageString.substring(0, tempSendMessageString.indexOf(" ")));
                    if (messagesDuplicated.contains(messageIdentifier)) {
                        ++duplicateCount;
                    } else {
                        messagesDuplicated.add(messageIdentifier);
                    }
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while parsing the file containing received messages", (Throwable)e);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the file containing received messages", (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error " + this.filePath + " the file containing received messages couldn't found"), (Throwable)e);
        }
        return duplicateCount;
    }
}

