/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.operations.clients;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.wso2.carbon.andes.event.stub.core.TopicNode;
import org.wso2.carbon.andes.event.stub.core.TopicRolePermission;
import org.wso2.carbon.andes.event.stub.service.AndesEventAdminServiceEventAdminException;
import org.wso2.carbon.andes.event.stub.service.AndesEventAdminServiceStub;

public class TopicAdminClient {
    String backendUrl = null;
    String SessionCookie = null;
    AndesEventAdminServiceStub stub = null;

    public TopicAdminClient(String backendUrl, String sessionCookie) throws AxisFault {
        this.backendUrl = backendUrl + "AndesEventAdminService.AndesEventAdminServiceHttpsSoap12Endpoint";
        this.SessionCookie = sessionCookie;
        this.stub = new AndesEventAdminServiceStub(this.backendUrl);
        this.configureCookie(this.stub._getServiceClient());
    }

    public void addTopic(String newTopicName) throws AndesEventAdminServiceEventAdminException, RemoteException {
        this.stub.addTopic(newTopicName);
    }

    public void removeTopic(String topicName) throws AndesEventAdminServiceEventAdminException, RemoteException {
        this.stub.removeTopic(topicName);
    }

    public TopicNode getTopicByName(String topicName) throws AndesEventAdminServiceEventAdminException, RemoteException {
        TopicNode[] topicNodes = this.stub.getAllTopics().getChildren();
        if (topicNodes != null && topicNodes.length > 0) {
            for (TopicNode topicNode : topicNodes) {
                if (!topicNode.getTopicName().equalsIgnoreCase(topicName)) continue;
                return topicNode;
            }
        }
        return null;
    }

    public void updatePermissionForTopic(String topicName, TopicRolePermission permissions) throws AndesEventAdminServiceEventAdminException, RemoteException {
        this.stub.updatePermission(topicName, new TopicRolePermission[]{permissions});
    }

    private void configureCookie(ServiceClient client) throws AxisFault {
        if (this.SessionCookie != null) {
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)this.SessionCookie);
        }
    }
}

