/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.operations.clients;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.wso2.carbon.andes.stub.AndesAdminServiceBrokerManagerAdminException;
import org.wso2.carbon.andes.stub.AndesAdminServiceStub;
import org.wso2.carbon.andes.stub.admin.types.Message;
import org.wso2.carbon.andes.stub.admin.types.Queue;
import org.wso2.carbon.andes.stub.admin.types.QueueRolePermission;
import org.wso2.mb.integration.common.clients.operations.clients.utils.AuthenticateStubUtil;

public class AndesAdminClient {
    String backendUrl = null;
    String sessionCookie = null;
    AndesAdminServiceStub stub = null;
    public static final String PUBLISHER_ROLE = "publisher";

    public AndesAdminClient(String backendUrl, String sessionCookie) throws AxisFault {
        this.backendUrl = backendUrl + "AndesAdminService";
        this.sessionCookie = sessionCookie;
        this.stub = new AndesAdminServiceStub(this.backendUrl);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.stub);
    }

    public void createQueue(String queue) throws AndesAdminServiceBrokerManagerAdminException, RemoteException {
        QueueRolePermission queueRolePermission = new QueueRolePermission();
        queueRolePermission.setRoleName(PUBLISHER_ROLE);
        queueRolePermission.setAllowedToConsume(true);
        queueRolePermission.setAllowedToPublish(true);
        this.stub.addQueueAndAssignPermission(queue, new QueueRolePermission[]{queueRolePermission});
    }

    public Message[] browseQueue(String queue, int startingIndex, int maximumMessageCount) throws AndesAdminServiceBrokerManagerAdminException, RemoteException {
        return this.stub.browseQueue(queue, (long)startingIndex, maximumMessageCount);
    }

    public void deleteQueue(String queue) throws AndesAdminServiceBrokerManagerAdminException, RemoteException {
        this.stub.deleteQueue(queue);
    }

    public void purgeQueue(String queue) throws RemoteException, AndesAdminServiceBrokerManagerAdminException {
        this.stub.purgeMessagesOfQueue(queue);
    }

    public Queue getQueueByName(String name) throws RemoteException, AndesAdminServiceBrokerManagerAdminException {
        return this.stub.getQueueByName(name);
    }

    public void updatePermissionForQueue(String queueName, QueueRolePermission permissions) throws AndesAdminServiceBrokerManagerAdminException, RemoteException {
        this.stub.updatePermission(queueName, new QueueRolePermission[]{permissions});
    }

    private void configureCookie(ServiceClient client) throws AxisFault {
        if (this.sessionCookie != null) {
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)this.sessionCookie);
        }
    }

    public Queue getDlcQueue() throws AndesAdminServiceBrokerManagerAdminException, RemoteException {
        return this.stub.getDLCQueue();
    }
}

