/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.configurations;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSClientConfiguration;
import org.wso2.mb.integration.common.clients.configurations.JMSHeaderProperty;
import org.wso2.mb.integration.common.clients.configurations.JMSHeaderPropertyType;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientConfigurationException;
import org.wso2.mb.integration.common.clients.operations.utils.ExchangeType;
import org.wso2.mb.integration.common.clients.operations.utils.JMSMessageType;

public class AndesJMSPublisherClientConfiguration
extends AndesJMSClientConfiguration {
    private String readMessagesFromFilePath = null;
    private String messagesContentToSet = null;
    private JMSMessageType jmsMessageType = JMSMessageType.TEXT;
    private long numberOfMessagesToSend = 10L;
    private long jmsMessageExpiryTime = 0L;
    private String filePathToWritePublishedMessages = null;
    private boolean transactionalSession;
    private List<JMSHeaderProperty> JMSHeaderProperties;
    private String JMSType;

    public AndesJMSPublisherClientConfiguration() {
    }

    public AndesJMSPublisherClientConfiguration(ExchangeType exchangeType, String destinationName) {
        super(exchangeType, destinationName);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public AndesJMSPublisherClientConfiguration(String hostName, int port, ExchangeType exchangeType, String destinationName) {
        super(hostName, port, exchangeType, destinationName);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public AndesJMSPublisherClientConfiguration(int port, ExchangeType exchangeType, String destinationName) {
        super(port, exchangeType, destinationName);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public AndesJMSPublisherClientConfiguration(String userName, String password, ExchangeType exchangeType, String destinationName) {
        super(userName, password, exchangeType, destinationName);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public AndesJMSPublisherClientConfiguration(int port, String userName, String password, ExchangeType exchangeType, String destinationName) {
        super(port, userName, password, exchangeType, destinationName);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public AndesJMSPublisherClientConfiguration(String userName, String password, String hostName, int port, ExchangeType exchangeType, String destinationName) {
        super(userName, password, hostName, port, exchangeType, destinationName);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public AndesJMSPublisherClientConfiguration(String xmlConfigFilePath) throws AndesClientConfigurationException {
        super(xmlConfigFilePath);
        try {
            XMLConfiguration config = new XMLConfiguration(xmlConfigFilePath);
            this.numberOfMessagesToSend = config.getLong("base.publisher.numberOfMessagesToSend", 10L);
            this.jmsMessageExpiryTime = config.getLong("base.publisher.jmsMessageExpiryTime", 0L);
            this.readMessagesFromFilePath = config.getString("base.publisher.readMessagesFromFilePath", null);
            this.messagesContentToSet = config.getString("base.publisher.messagesContentToSet", null);
            this.jmsMessageType = JMSMessageType.valueOf(config.getString("base.publisher.jmsMessageType", "TEXT"));
            this.filePathToWritePublishedMessages = config.getString("base.publisher.filePathToWritePublishedMessages", null);
            this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
        }
        catch (ConfigurationException e) {
            throw new AndesClientConfigurationException("Error in reading xml configuration file. Make sure the file exists.", e);
        }
        catch (IllegalArgumentException e) {
            throw new AndesClientConfigurationException("Invalid message type used. Use either 'TEXT', 'BYTE', 'MAP', 'OBJECT' or 'STREAM'.", e);
        }
    }

    public AndesJMSPublisherClientConfiguration(AndesJMSClientConfiguration config) {
        super(config);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public AndesJMSPublisherClientConfiguration(String userName, String password, String hostName, int port, ExchangeType exchangeType, String destinationName, String sslAlias, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword) {
        super(userName, password, hostName, port, exchangeType, destinationName, sslAlias, trustStorePath, trustStorePassword, keyStorePath, keyStorePassword);
        this.JMSHeaderProperties = new ArrayList<JMSHeaderProperty>(5);
    }

    public String getReadMessagesFromFilePath() {
        return this.readMessagesFromFilePath;
    }

    public void setReadMessagesFromFilePath(String readMessagesFromFilePath) throws AndesClientConfigurationException, FileNotFoundException {
        File messagesFilePath = new File(readMessagesFromFilePath);
        if (!messagesFilePath.exists() || messagesFilePath.isDirectory()) {
            throw new FileNotFoundException("File is missing : " + messagesFilePath);
        }
        this.readMessagesFromFilePath = readMessagesFromFilePath;
    }

    public JMSMessageType getJMSMessageType() {
        return this.jmsMessageType;
    }

    public void setJMSHeaderProperty(String key, Object value, JMSHeaderPropertyType type) {
        this.JMSHeaderProperties.add(new JMSHeaderProperty(key, value, type));
    }

    public void setJMSType(String jmsType) {
        this.JMSType = jmsType;
    }

    public String getJMSType() {
        return this.JMSType;
    }

    public void setJMSMessageType(JMSMessageType jmsMessageType) {
        this.jmsMessageType = jmsMessageType;
    }

    public long getNumberOfMessagesToSend() {
        return this.numberOfMessagesToSend;
    }

    public void setNumberOfMessagesToSend(long numberOfMessagesToSend) throws AndesClientConfigurationException {
        if (0L >= numberOfMessagesToSend) {
            throw new AndesClientConfigurationException("The number of messages to send cannot be less than 1");
        }
        this.numberOfMessagesToSend = numberOfMessagesToSend;
    }

    public String getFilePathToWritePublishedMessages() {
        return this.filePathToWritePublishedMessages;
    }

    public void setFilePathToWritePublishedMessages(String filePathToWritePublishedMessages) {
        this.filePathToWritePublishedMessages = filePathToWritePublishedMessages;
    }

    public long getJMSMessageExpiryTime() {
        return this.jmsMessageExpiryTime;
    }

    public void setJMSMessageExpiryTime(long jmsMessageExpiryTime) throws AndesClientConfigurationException {
        if (0L > jmsMessageExpiryTime) {
            throw new AndesClientConfigurationException("Message expiry time cannot be less than 0");
        }
        this.jmsMessageExpiryTime = jmsMessageExpiryTime;
    }

    @Override
    public String toString() {
        return super.toString() + "MessagesContentToSet=" + this.messagesContentToSet + "\nReadMessagesFromFilePath=" + this.readMessagesFromFilePath + "\nJmsMessageType=" + (Object)((Object)this.jmsMessageType) + "\nNumberOfMessagesToSend=" + this.numberOfMessagesToSend + "\nJmsMessageExpiryTime=" + this.jmsMessageExpiryTime + "\n";
    }

    public AndesJMSPublisherClientConfiguration clone() throws CloneNotSupportedException {
        return (AndesJMSPublisherClientConfiguration)super.clone();
    }

    public boolean isTransactionalSession() {
        return this.transactionalSession;
    }

    public void setTransactionalSession(boolean transactionalSession) {
        this.transactionalSession = transactionalSession;
    }

    public List<JMSHeaderProperty> getJMSHeaderProperties() {
        return this.JMSHeaderProperties;
    }

    public String getMessagesContentToSet() {
        return this.messagesContentToSet;
    }

    public void setMessagesContentOfConfiguration(String messagesContentToSet) {
        this.messagesContentToSet = messagesContentToSet;
    }
}

