/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.configurations;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSClientConfiguration;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientConfigurationException;
import org.wso2.mb.integration.common.clients.operations.utils.ExchangeType;
import org.wso2.mb.integration.common.clients.operations.utils.JMSAcknowledgeMode;

public class AndesJMSConsumerClientConfiguration
extends AndesJMSClientConfiguration {
    private static Logger log = Logger.getLogger(AndesJMSConsumerClientConfiguration.class);
    private long unSubscribeAfterEachMessageCount = Long.MAX_VALUE;
    private long rollbackAfterEachMessageCount = Long.MAX_VALUE;
    private long recoverAfterEachMessageCount = Long.MAX_VALUE;
    private long commitAfterEachMessageCount = Long.MAX_VALUE;
    private long acknowledgeAfterEachMessageCount = Long.MAX_VALUE;
    private String filePathToWriteReceivedMessages = null;
    private long maximumMessagesToReceived = Long.MAX_VALUE;
    private String subscriptionID = null;
    private boolean durable = false;
    private JMSAcknowledgeMode acknowledgeMode = JMSAcknowledgeMode.AUTO_ACKNOWLEDGE;
    private boolean async = false;
    private String selectors = null;
    private List<String> receivedMessages = new ArrayList<String>();

    public AndesJMSConsumerClientConfiguration() {
    }

    public AndesJMSConsumerClientConfiguration(ExchangeType exchangeType, String destinationName) {
        super(exchangeType, destinationName);
    }

    public AndesJMSConsumerClientConfiguration(String hostName, int port, ExchangeType exchangeType, String destinationName) {
        super(hostName, port, exchangeType, destinationName);
    }

    public AndesJMSConsumerClientConfiguration(int port, ExchangeType exchangeType, String destinationName) {
        super(port, exchangeType, destinationName);
    }

    public AndesJMSConsumerClientConfiguration(String userName, String password, ExchangeType exchangeType, String destinationName) {
        super(userName, password, exchangeType, destinationName);
    }

    public AndesJMSConsumerClientConfiguration(int port, String userName, String password, ExchangeType exchangeType, String destinationName) {
        super(port, userName, password, exchangeType, destinationName);
    }

    public AndesJMSConsumerClientConfiguration(String userName, String password, String hostName, int port, ExchangeType exchangeType, String destinationName) {
        super(userName, password, hostName, port, exchangeType, destinationName);
    }

    public AndesJMSConsumerClientConfiguration(String xmlConfigFilePath) throws AndesClientConfigurationException {
        super(xmlConfigFilePath);
        try {
            XMLConfiguration config = new XMLConfiguration(xmlConfigFilePath);
            this.unSubscribeAfterEachMessageCount = config.getLong("base.consumer.unSubscribeAfterEachMessageCount", Long.MAX_VALUE);
            this.rollbackAfterEachMessageCount = config.getLong("base.consumer.rollbackAfterEachMessageCount", Long.MAX_VALUE);
            this.recoverAfterEachMessageCount = config.getLong("base.consumer.recoverAfterEachMessageCount", Long.MAX_VALUE);
            this.commitAfterEachMessageCount = config.getLong("base.consumer.commitAfterEachMessageCount", Long.MAX_VALUE);
            this.acknowledgeAfterEachMessageCount = config.getLong("base.consumer.acknowledgeAfterEachMessageCount", Long.MAX_VALUE);
            this.filePathToWriteReceivedMessages = config.getString("base.consumer.filePathToWriteReceivedMessages", null);
            this.maximumMessagesToReceived = config.getLong("base.consumer.maximumMessagesToReceived", Long.MAX_VALUE);
            this.subscriptionID = config.getString("base.consumer.subscriptionID", null);
            this.durable = config.getBoolean("base.consumer.durable", false);
            this.async = config.getBoolean("base.consumer.async", true);
            this.selectors = config.getString("base.consumer.selectors", null);
            this.acknowledgeMode = JMSAcknowledgeMode.valueOf(config.getString("base.consumer.acknowledgeMode", "AUTO_ACKNOWLEDGE"));
        }
        catch (ConfigurationException e) {
            throw new AndesClientConfigurationException("Error in reading xml configuration file. Make sure the file exists.", e);
        }
        catch (IllegalArgumentException e) {
            throw new AndesClientConfigurationException("Invalid acknowledge mode used. Use a value either of the values : SESSION_TRANSACTED, AUTO_ACKNOWLEDGE, CLIENT_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE", e);
        }
    }

    public AndesJMSConsumerClientConfiguration(AndesJMSClientConfiguration config) {
        super(config);
    }

    public AndesJMSConsumerClientConfiguration(String userName, String password, String hostName, int port, ExchangeType exchangeType, String destinationName, String sslAlias, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword) {
        super(userName, password, hostName, port, exchangeType, destinationName, sslAlias, trustStorePath, trustStorePassword, keyStorePath, keyStorePassword);
    }

    public long getUnSubscribeAfterEachMessageCount() {
        return this.unSubscribeAfterEachMessageCount;
    }

    public void setUnSubscribeAfterEachMessageCount(long unSubscribeAfterEachMessageCount) throws AndesClientConfigurationException {
        if (0L >= unSubscribeAfterEachMessageCount) {
            throw new AndesClientConfigurationException("Value cannot be less than 0");
        }
        this.unSubscribeAfterEachMessageCount = unSubscribeAfterEachMessageCount;
    }

    public long getRollbackAfterEachMessageCount() {
        return this.rollbackAfterEachMessageCount;
    }

    public long getRecoverAfterEachMessageCount() {
        return this.recoverAfterEachMessageCount;
    }

    public void setRollbackAfterEachMessageCount(long rollbackAfterEachMessageCount) throws AndesClientConfigurationException {
        if (0L >= rollbackAfterEachMessageCount) {
            throw new AndesClientConfigurationException("Value cannot be less than 0");
        }
        this.rollbackAfterEachMessageCount = rollbackAfterEachMessageCount;
    }

    public void setRecoverAfterEachMessageCount(long recoverAfterEachMessageCount) throws AndesClientConfigurationException {
        if (0L >= recoverAfterEachMessageCount) {
            throw new AndesClientConfigurationException("Value cannot be less than 0");
        }
        this.recoverAfterEachMessageCount = recoverAfterEachMessageCount;
    }

    public long getCommitAfterEachMessageCount() {
        return this.commitAfterEachMessageCount;
    }

    public void setCommitAfterEachMessageCount(long commitAfterEachMessageCount) throws AndesClientConfigurationException {
        if (0L >= commitAfterEachMessageCount) {
            throw new AndesClientConfigurationException("Value cannot be less than 0");
        }
        this.commitAfterEachMessageCount = commitAfterEachMessageCount;
    }

    public long getAcknowledgeAfterEachMessageCount() {
        return this.acknowledgeAfterEachMessageCount;
    }

    public void setAcknowledgeAfterEachMessageCount(long acknowledgeAfterEachMessageCount) throws AndesClientConfigurationException {
        if (0L >= acknowledgeAfterEachMessageCount) {
            throw new AndesClientConfigurationException("Value cannot be less than 0");
        }
        this.acknowledgeAfterEachMessageCount = acknowledgeAfterEachMessageCount;
    }

    public String getFilePathToWriteReceivedMessages() {
        return this.filePathToWriteReceivedMessages;
    }

    public void setFilePathToWriteReceivedMessages(String filePathToWriteReceivedMessages) {
        this.filePathToWriteReceivedMessages = filePathToWriteReceivedMessages;
    }

    public long getMaximumMessagesToReceived() {
        return this.maximumMessagesToReceived;
    }

    public void setMaximumMessagesToReceived(long maximumMessagesToReceived) throws AndesClientConfigurationException {
        if (0L >= maximumMessagesToReceived) {
            throw new AndesClientConfigurationException("The maximum number of messages to receive cannot be less than 1");
        }
        this.maximumMessagesToReceived = maximumMessagesToReceived;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSubscriptionID(String subscriptionID) throws AndesClientConfigurationException {
        if (this.durable) {
            if (!StringUtils.isNotEmpty((String)subscriptionID)) throw new AndesClientConfigurationException("Subscription ID cannot be null or empty for an durable topic");
            this.subscriptionID = subscriptionID;
            return;
        } else {
            this.subscriptionID = subscriptionID;
            log.warn((Object)"Setting subscription ID for non-durable topics. Subscription ID is not necessary for non-durable topics or queues");
        }
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable, String subscriptionID) throws AndesClientConfigurationException {
        if (durable) {
            if (StringUtils.isNotEmpty((String)subscriptionID)) {
                this.subscriptionID = subscriptionID;
            } else {
                throw new AndesClientConfigurationException("Subscription ID cannot be null or empty for an durable topic");
            }
        }
        this.durable = durable;
    }

    public JMSAcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(JMSAcknowledgeMode acknowledgeMode) throws AndesClientConfigurationException {
        this.acknowledgeMode = acknowledgeMode;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getSelectors() {
        return this.selectors;
    }

    public void setSelectors(String selectors) {
        this.selectors = selectors;
    }

    public List<String> getReceivedMessages() {
        return this.receivedMessages;
    }

    public void addReceivedMessage(String receivedMessages) {
        this.receivedMessages.add(receivedMessages);
    }

    @Override
    public String toString() {
        return super.toString() + "UnSubscribeAfterEachMessageCount=" + this.unSubscribeAfterEachMessageCount + "\nRollbackAfterEachMessageCount=" + this.rollbackAfterEachMessageCount + "\nRecoverAfterEachMessageCount=" + this.recoverAfterEachMessageCount + "\nCommitAfterEachMessageCount=" + this.commitAfterEachMessageCount + "\nAcknowledgeAfterEachMessageCount=" + this.acknowledgeAfterEachMessageCount + "\nFilePathToWriteReceivedMessages=" + this.filePathToWriteReceivedMessages + "\nReceivedMessages=" + this.receivedMessages + "\nMaximumMessagesToReceived=" + this.maximumMessagesToReceived + "\nSubscriptionID=" + this.subscriptionID + "\nDurable=" + this.durable + "\nAcknowledgeMode=" + (Object)((Object)this.acknowledgeMode) + "\nAsync=" + this.async + "\nSelectors=" + this.selectors + "\n";
    }

    public AndesJMSConsumerClientConfiguration clone() throws CloneNotSupportedException {
        return (AndesJMSConsumerClientConfiguration)super.clone();
    }
}

