/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients.configurations;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientConfigurationException;
import org.wso2.mb.integration.common.clients.operations.utils.ExchangeType;

public class AndesJMSClientConfiguration
implements Cloneable {
    private static final String TEMP_DESTINATION_NAME = "temporaryDestination";
    private int port;
    private String hostName;
    private String userName;
    private String password;
    private String connectionString;
    private ExchangeType exchangeType;
    private String destinationName;
    private long printsPerMessageCount;
    private long runningDelay;
    private String filePathToWriteStatistics;
    private String queryStringForConnection = "";

    public AndesJMSClientConfiguration() {
        this(ExchangeType.QUEUE, TEMP_DESTINATION_NAME);
    }

    public AndesJMSClientConfiguration(ExchangeType exchangeType, String destinationName) {
        this("admin", "admin", "127.0.0.1", 5672, exchangeType, destinationName);
    }

    public AndesJMSClientConfiguration(String hostName, int port, ExchangeType exchangeType, String destinationName) {
        this("admin", "admin", hostName, port, exchangeType, destinationName);
    }

    public AndesJMSClientConfiguration(int port, ExchangeType exchangeType, String destinationName) {
        this("admin", "admin", "127.0.0.1", port, exchangeType, destinationName);
    }

    public AndesJMSClientConfiguration(String userName, String password, ExchangeType exchangeType, String destinationName) {
        this(userName, password, "127.0.0.1", 5672, exchangeType, destinationName);
    }

    public AndesJMSClientConfiguration(int port, String userName, String password, ExchangeType exchangeType, String destinationName) {
        this(userName, password, "127.0.0.1", port, exchangeType, destinationName);
    }

    public AndesJMSClientConfiguration(String userName, String password, String hostName, int port, ExchangeType exchangeType, String destinationName) {
        this.exchangeType = exchangeType;
        this.destinationName = destinationName;
        this.userName = userName;
        this.password = password;
        this.hostName = hostName;
        this.port = port;
        this.createConnectionString();
        this.printsPerMessageCount = 1L;
        this.runningDelay = 0L;
    }

    public AndesJMSClientConfiguration(String xmlConfigFilePath) throws AndesClientConfigurationException {
        try {
            XMLConfiguration config = new XMLConfiguration(xmlConfigFilePath);
            this.exchangeType = ExchangeType.valueOf(config.getString("base.exchangeType", "QUEUE"));
            this.destinationName = config.getString("base.destinationName", TEMP_DESTINATION_NAME);
            this.userName = config.getString("base.userName", "admin");
            this.password = config.getString("base.password", "admin");
            this.hostName = config.getString("base.hostName", "carbon");
            this.port = config.getInt("base.port", 5672);
            this.queryStringForConnection = config.getString("base.queryStringForConnection", "");
            this.createConnectionString();
            this.printsPerMessageCount = config.getLong("base.printsPerMessageCount", 1L);
            this.runningDelay = config.getLong("base.runningDelay", 0L);
        }
        catch (ConfigurationException e) {
            throw new AndesClientConfigurationException("Error in reading xml configuration file. Make sure the file exists.", e);
        }
        catch (IllegalArgumentException e) {
            throw new AndesClientConfigurationException("Invalid exchange type used. Use either 'QUEUE' or 'TOPIC'.", e);
        }
    }

    public AndesJMSClientConfiguration(AndesJMSClientConfiguration config) {
        this.connectionString = config.getConnectionString();
        this.exchangeType = config.getExchangeType();
        this.destinationName = config.getDestinationName();
        this.printsPerMessageCount = config.getPrintsPerMessageCount();
        this.runningDelay = config.getRunningDelay();
    }

    public AndesJMSClientConfiguration(String userName, String password, String hostName, int port, ExchangeType exchangeType, String destinationName, String sslAlias, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword) {
        this.exchangeType = exchangeType;
        this.destinationName = destinationName;
        this.userName = userName;
        this.password = password;
        this.hostName = hostName;
        this.port = port;
        this.queryStringForConnection = keyStorePath == null || keyStorePassword == null ? "?ssl='true'&ssl_cert_alias='" + sslAlias + "'&trust_store='" + trustStorePath + "'&trust_store_password='" + trustStorePassword + "'" : "?ssl='true'&ssl_cert_alias='" + sslAlias + "'&trust_store='" + trustStorePath + "'&trust_store_password='" + trustStorePassword + "'&key_store='" + keyStorePath + "'&key_store_password='" + keyStorePassword + "'";
        this.createConnectionString();
        this.printsPerMessageCount = 1L;
        this.runningDelay = 0L;
    }

    private void createConnectionString() {
        this.connectionString = "amqp://" + this.userName + ":" + this.password + "@" + "carbon" + "/" + "carbon" + "?brokerlist='tcp://" + this.hostName + ":" + this.port + this.queryStringForConnection + "'";
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.createConnectionString();
    }

    public void setPassword(String password) {
        this.password = password;
        this.createConnectionString();
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.createConnectionString();
    }

    public void setPort(int port) {
        this.port = port;
        this.createConnectionString();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public ExchangeType getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(ExchangeType exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public long getPrintsPerMessageCount() {
        return this.printsPerMessageCount;
    }

    public void setPrintsPerMessageCount(long printsPerMessageCount) throws AndesClientConfigurationException {
        if (0L >= printsPerMessageCount) {
            throw new AndesClientConfigurationException("Prints per message count cannot be less than one");
        }
        this.printsPerMessageCount = printsPerMessageCount;
    }

    public long getRunningDelay() {
        return this.runningDelay;
    }

    public void setRunningDelay(long runningDelay) throws AndesClientConfigurationException {
        if (0L > runningDelay) {
            throw new AndesClientConfigurationException("Running delay cannot be less than 0");
        }
        this.runningDelay = runningDelay;
    }

    public String getFilePathToWriteStatistics() {
        return this.filePathToWriteStatistics;
    }

    public void setFilePathToWriteStatistics(String filePathToPrintStatistics) {
        this.filePathToWriteStatistics = filePathToPrintStatistics;
    }

    public String toString() {
        return "ConnectionString=" + this.connectionString + "\nExchangeType=" + (Object)((Object)this.exchangeType) + "\nPrintsPerMessageCount=" + this.printsPerMessageCount + "\nDestinationName=" + this.destinationName + "\nRunningDelay=" + this.runningDelay + "\n";
    }
}

