/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.wso2.mb.integration.common.clients.AndesJMSBase;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSPublisherClientConfiguration;
import org.wso2.mb.integration.common.clients.configurations.JMSHeaderProperty;
import org.wso2.mb.integration.common.clients.configurations.JMSHeaderPropertyType;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientException;
import org.wso2.mb.integration.common.clients.operations.utils.AndesClientUtils;
import org.wso2.mb.integration.common.clients.operations.utils.JMSMessageType;

public class AndesJMSPublisher
extends AndesJMSBase
implements Runnable {
    private static Logger log = Logger.getLogger(AndesJMSPublisher.class);
    private AndesJMSPublisherClientConfiguration publisherConfig;
    private long sentMessageCount;
    private long firstMessagePublishTimestamp;
    private long lastMessagePublishTimestamp;
    private Connection connection;
    private Session session;
    private MessageProducer sender;
    private String messageContent = null;

    public AndesJMSPublisher(AndesJMSPublisherClientConfiguration config, boolean createPublisher) throws NamingException, JMSException {
        super(config);
        this.publisherConfig = config;
        if (null != config.getMessagesContentToSet()) {
            this.messageContent = config.getMessagesContentToSet();
        }
        if (createPublisher) {
            ConnectionFactory connFactory = (ConnectionFactory)super.getInitialContext().lookup("andesConnectionfactory");
            this.connection = connFactory.createConnection();
            this.connection.start();
            this.session = config.isTransactionalSession() ? this.connection.createSession(true, 0) : this.connection.createSession(false, 1);
            Destination destination = (Destination)super.getInitialContext().lookup(this.publisherConfig.getDestinationName());
            this.sender = this.session.createProducer(destination);
        }
    }

    @Override
    public void startClient() throws AndesClientException, IOException {
        if (null != this.connection && null != this.session && null != this.sender) {
            if (null != this.publisherConfig.getReadMessagesFromFilePath()) {
                this.getMessageContentFromFile();
            }
        } else {
            throw new AndesClientException("The connection, session and message sender is not assigned.");
        }
        Thread subscriberThread = new Thread(this);
        subscriberThread.start();
    }

    @Override
    public void stopClient() throws JMSException {
        if (null != this.connection && null != this.session && null != this.sender) {
            long threadID = Thread.currentThread().getId();
            log.info((Object)("Closing publisher | ThreadID : " + threadID));
            this.sender.close();
            this.session.close();
            this.connection.close();
            this.sender = null;
            this.session = null;
            this.connection = null;
            log.info((Object)("Publisher closed | ThreadID : " + threadID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMessageContentFromFile() throws IOException {
        if (null != this.publisherConfig.getReadMessagesFromFilePath()) {
            try (BufferedReader br = new BufferedReader(new FileReader(this.publisherConfig.getReadMessagesFromFilePath()));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append('\n');
                    line = br.readLine();
                }
                sb.replace(sb.length() - 1, sb.length() + 1, "");
                this.messageContent = sb.toString();
            }
        }
    }

    @Override
    public void run() {
        try {
            BytesMessage message = null;
            long threadID = Thread.currentThread().getId();
            while (this.sentMessageCount < this.publisherConfig.getNumberOfMessagesToSend()) {
                if (JMSMessageType.TEXT == this.publisherConfig.getJMSMessageType()) {
                    message = null != this.publisherConfig.getReadMessagesFromFilePath() || null != this.messageContent ? this.session.createTextMessage(this.messageContent) : this.session.createTextMessage(MessageFormat.format("Sending Message:{0} ThreadID:{1}", this.sentMessageCount, threadID));
                } else if (JMSMessageType.BYTE == this.publisherConfig.getJMSMessageType()) {
                    message = this.session.createBytesMessage();
                } else if (JMSMessageType.MAP == this.publisherConfig.getJMSMessageType()) {
                    MapMessage mapMessage = this.session.createMapMessage();
                    if (null != this.publisherConfig.getReadMessagesFromFilePath()) {
                        String[] entries = this.messageContent.split(System.getProperty("line.separator"));
                        for (int i = 0; i < entries.length; ++i) {
                            mapMessage.setString("key" + i, entries[i]);
                        }
                    }
                    message = mapMessage;
                } else if (JMSMessageType.OBJECT == this.publisherConfig.getJMSMessageType()) {
                    message = this.session.createObjectMessage();
                } else if (JMSMessageType.STREAM == this.publisherConfig.getJMSMessageType()) {
                    message = this.session.createStreamMessage();
                }
                String jmsType = this.publisherConfig.getJMSType();
                if (message != null && null != jmsType && !jmsType.isEmpty()) {
                    message.setJMSType(jmsType);
                }
                this.setMessageProperties((Message)message);
                if (null == message) continue;
                this.sender.send((Message)message, 2, 0, this.publisherConfig.getJMSMessageExpiryTime());
                if (this.getConfig().isTransactionalSession()) {
                    this.session.commit();
                }
                if (message instanceof TextMessage && null != this.publisherConfig.getFilePathToWritePublishedMessages()) {
                    AndesClientUtils.writePublishedMessagesToFile(((TextMessage)message).getText(), this.publisherConfig.getFilePathToWritePublishedMessages());
                }
                ++this.sentMessageCount;
                long currentTimeStamp = System.currentTimeMillis();
                if (0L == this.firstMessagePublishTimestamp) {
                    this.firstMessagePublishTimestamp = currentTimeStamp;
                }
                this.lastMessagePublishTimestamp = currentTimeStamp;
                if (0L == this.sentMessageCount % this.publisherConfig.getPrintsPerMessageCount()) {
                    if (null != this.publisherConfig.getReadMessagesFromFilePath()) {
                        log.info((Object)("[SEND] (FROM FILE) ThreadID:" + threadID + " Destination(" + this.publisherConfig.getExchangeType().getType() + "):" + this.publisherConfig.getDestinationName() + " SentMessageCount:" + this.sentMessageCount + " CountToSend:" + this.publisherConfig.getNumberOfMessagesToSend()));
                    } else {
                        log.info((Object)("[SEND] (INBUILT MESSAGE) ThreadID:" + threadID + " Destination(" + this.publisherConfig.getExchangeType().getType() + "):" + this.publisherConfig.getDestinationName() + " SentMessageCount:" + this.sentMessageCount + " CountToSend:" + this.publisherConfig.getNumberOfMessagesToSend()));
                    }
                }
                if (null != this.publisherConfig.getFilePathToWriteStatistics()) {
                    String statisticsString = ",,,," + Long.toString(currentTimeStamp) + "," + Double.toString(this.getPublisherTPS());
                    AndesClientUtils.writeStatisticsToFile(statisticsString, this.publisherConfig.getFilePathToWriteStatistics());
                }
                if (0L >= this.publisherConfig.getRunningDelay()) continue;
                try {
                    Thread.sleep(this.publisherConfig.getRunningDelay());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.stopClient();
        }
        catch (JMSException e) {
            throw new RuntimeException("Error while publishing messages", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing statistics", e);
        }
    }

    private void setMessageProperties(Message message) throws JMSException {
        List<JMSHeaderProperty> headerPropertyList = this.publisherConfig.getJMSHeaderProperties();
        for (JMSHeaderProperty jmsHeaderProperty : headerPropertyList) {
            JMSHeaderPropertyType type = jmsHeaderProperty.getType();
            String propertyKey = jmsHeaderProperty.getKey();
            Object propertyValue = jmsHeaderProperty.getValue();
            switch (type) {
                case OBJECT: {
                    message.setObjectProperty(propertyKey, propertyValue);
                    break;
                }
                case BYTE: {
                    message.setByteProperty(propertyKey, ((Byte)propertyValue).byteValue());
                    break;
                }
                case BOOLEAN: {
                    message.setBooleanProperty(propertyKey, ((Boolean)propertyValue).booleanValue());
                    break;
                }
                case DOUBLE: {
                    message.setDoubleProperty(propertyKey, ((Double)propertyValue).doubleValue());
                    break;
                }
                case FLOAT: {
                    message.setFloatProperty(propertyKey, ((Float)propertyValue).floatValue());
                    break;
                }
                case SHORT: {
                    message.setShortProperty(propertyKey, ((Short)propertyValue).shortValue());
                    break;
                }
                case STRING: {
                    message.setStringProperty(propertyKey, (String)propertyValue);
                    break;
                }
                case INTEGER: {
                    message.setIntProperty(propertyKey, ((Integer)propertyValue).intValue());
                    break;
                }
                case LONG: {
                    message.setLongProperty(propertyKey, ((Long)propertyValue).longValue());
                }
            }
        }
    }

    public long getSentMessageCount() {
        return this.sentMessageCount;
    }

    public double getPublisherTPS() {
        if (0L == this.lastMessagePublishTimestamp - this.firstMessagePublishTimestamp) {
            return (double)this.sentMessageCount / 0.001;
        }
        return (double)this.sentMessageCount / ((double)(this.lastMessagePublishTimestamp - this.firstMessagePublishTimestamp) / 1000.0);
    }

    @Override
    public AndesJMSPublisherClientConfiguration getConfig() {
        return this.publisherConfig;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public MessageProducer getSender() {
        return this.sender;
    }

    public void setSender(MessageProducer sender) {
        this.sender = sender;
    }
}

