/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients;

import java.io.IOException;
import java.util.Properties;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSClientConfiguration;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientException;

public abstract class AndesJMSBase {
    protected final AndesJMSClientConfiguration jmsConfig;
    private InitialContext initialContext;

    protected AndesJMSBase(AndesJMSClientConfiguration config) throws NamingException {
        this.jmsConfig = config;
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.wso2.andes.jndi.PropertiesFileInitialContextFactory");
        properties.put("connectionfactory.andesConnectionfactory", this.jmsConfig.getConnectionString());
        properties.put(this.jmsConfig.getExchangeType().getType() + "." + this.jmsConfig.getDestinationName(), this.jmsConfig.getDestinationName());
        this.initialContext = new InitialContext(properties);
    }

    public InitialContext getInitialContext() {
        return this.initialContext;
    }

    public abstract void startClient() throws JMSException, NamingException, IOException, AndesClientException;

    public abstract void stopClient() throws JMSException, AndesClientException;

    public abstract AndesJMSClientConfiguration getConfig();
}

