/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.common.clients;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.wso2.mb.integration.common.clients.AndesJMSConsumer;
import org.wso2.mb.integration.common.clients.AndesJMSPublisher;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSClientConfiguration;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSConsumerClientConfiguration;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSPublisherClientConfiguration;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientException;
import org.wso2.mb.integration.common.clients.operations.utils.AndesClientOutputParser;
import org.wso2.mb.integration.common.clients.operations.utils.AndesClientUtils;

public class AndesClient {
    private static Logger log = Logger.getLogger(AndesClient.class);
    private long startDelay = 0L;
    List<AndesJMSConsumer> consumers = new ArrayList<AndesJMSConsumer>();
    List<AndesJMSPublisher> publishers = new ArrayList<AndesJMSPublisher>();

    public AndesClient(AndesJMSClientConfiguration config, boolean createConsumersAndProducers) throws NamingException, JMSException, AndesClientException, IOException {
        this(config, 1, createConsumersAndProducers);
    }

    public AndesClient(AndesJMSClientConfiguration config, int numberOfThreads, boolean createConsumersAndProducers) throws IOException, JMSException, NamingException, AndesClientException {
        if (0 < numberOfThreads) {
            if (config instanceof AndesJMSConsumerClientConfiguration && null != ((AndesJMSConsumerClientConfiguration)config).getFilePathToWriteReceivedMessages()) {
                AndesClientUtils.initializeReceivedMessagesPrintWriter(((AndesJMSConsumerClientConfiguration)config).getFilePathToWriteReceivedMessages());
            }
            if (config instanceof AndesJMSPublisherClientConfiguration && null != ((AndesJMSPublisherClientConfiguration)config).getFilePathToWritePublishedMessages()) {
                AndesClientUtils.initializePublishedPrintWriter(((AndesJMSPublisherClientConfiguration)config).getFilePathToWritePublishedMessages());
            }
            for (int i = 0; i < numberOfThreads; ++i) {
                if (config instanceof AndesJMSConsumerClientConfiguration) {
                    this.consumers.add(new AndesJMSConsumer((AndesJMSConsumerClientConfiguration)config, createConsumersAndProducers));
                    continue;
                }
                if (!(config instanceof AndesJMSPublisherClientConfiguration)) continue;
                this.publishers.add(new AndesJMSPublisher((AndesJMSPublisherClientConfiguration)config, createConsumersAndProducers));
            }
        } else {
            throw new AndesClientException("The amount of subscribers cannot be less than 1. Value entered is " + Integer.toString(numberOfThreads));
        }
    }

    public void startClient() throws AndesClientException, JMSException, IOException {
        boolean isStartDelaySet = this.startDelay > 0L;
        for (AndesJMSConsumer consumer : this.consumers) {
            consumer.startClient();
            if (!isStartDelaySet) continue;
            AndesClientUtils.sleepForInterval(this.startDelay);
        }
        for (AndesJMSPublisher publisher : this.publishers) {
            publisher.startClient();
            if (!isStartDelaySet) continue;
            AndesClientUtils.sleepForInterval(this.startDelay);
        }
    }

    public void stopClient() throws JMSException {
        for (AndesJMSConsumer consumer : this.consumers) {
            consumer.stopClient();
        }
        for (AndesJMSPublisher publisher : this.publishers) {
            publisher.stopClient();
        }
        log.info((Object)("TPS:" + this.getConsumerTPS() + " AverageLatency:" + this.getAverageLatency()));
    }

    public long getReceivedMessageCount() {
        long allReceivedMessageCount = 0L;
        for (AndesJMSConsumer consumer : this.consumers) {
            allReceivedMessageCount += consumer.getReceivedMessageCount().get();
        }
        return allReceivedMessageCount;
    }

    public double getConsumerTPS() {
        double tps = 0.0;
        for (AndesJMSConsumer consumer : this.consumers) {
            tps += consumer.getConsumerTPS();
        }
        return tps / (double)this.consumers.size();
    }

    public double getAverageLatency() {
        double averageLatency = 0.0;
        for (AndesJMSConsumer consumer : this.consumers) {
            averageLatency += consumer.getAverageLatency();
        }
        return averageLatency / (double)this.consumers.size();
    }

    public long getSentMessageCount() {
        long allSentMessageCount = 0L;
        for (AndesJMSPublisher publisher : this.publishers) {
            allSentMessageCount += publisher.getSentMessageCount();
        }
        return allSentMessageCount;
    }

    public double getPublisherTPS() {
        double tps = 0.0;
        for (AndesJMSPublisher publisher : this.publishers) {
            tps += publisher.getPublisherTPS();
        }
        return tps / (double)this.publishers.size();
    }

    public Map<Long, Integer> checkIfMessagesAreDuplicated() throws IOException {
        if (!this.consumers.isEmpty()) {
            AndesClientUtils.flushPrintWriters();
            AndesClientOutputParser andesClientOutputParser = new AndesClientOutputParser(this.consumers.get(0).getConfig().getFilePathToWriteReceivedMessages());
            return andesClientOutputParser.getDuplicatedMessages();
        }
        return null;
    }

    public boolean checkIfMessagesAreInOrder() throws IOException {
        if (!this.consumers.isEmpty()) {
            AndesClientOutputParser andesClientOutputParser = new AndesClientOutputParser(this.consumers.get(0).getConfig().getFilePathToWriteReceivedMessages());
            return andesClientOutputParser.checkIfMessagesAreInOrder();
        }
        return false;
    }

    public boolean transactedOperation(long operationOccurredIndex) throws IOException {
        if (0 < this.consumers.size()) {
            AndesClientOutputParser andesClientOutputParser = new AndesClientOutputParser(this.consumers.get(0).getConfig().getFilePathToWriteReceivedMessages());
            return andesClientOutputParser.transactedOperations(operationOccurredIndex);
        }
        return false;
    }

    public boolean checkIfTransactedRollbackPreservesOrder(long messagesPerRollback) throws IOException {
        if (0 < this.consumers.size()) {
            AndesClientOutputParser andesClientOutputParser = new AndesClientOutputParser(this.consumers.get(0).getConfig().getFilePathToWriteReceivedMessages());
            return andesClientOutputParser.checkIfTransactedRollbackPreservesOrder(messagesPerRollback);
        }
        return false;
    }

    public long getTotalNumberOfDuplicates() throws IOException {
        if (0 < this.consumers.size()) {
            AndesClientOutputParser andesClientOutputParser = new AndesClientOutputParser(this.consumers.get(0).getConfig().getFilePathToWriteReceivedMessages());
            return andesClientOutputParser.numberDuplicatedMessages();
        }
        return -1L;
    }

    public void setStartDelay(long startDelay) {
        this.startDelay = startDelay;
    }

    public List<AndesJMSConsumer> getConsumers() {
        return this.consumers;
    }

    public List<AndesJMSPublisher> getPublishers() {
        return this.publishers;
    }

    public List<String> getReceivedMessages() {
        return this.consumers.get(0).getConfig().getReceivedMessages();
    }
}

