/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.dataservices.integration.common.clients;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.ui.stub.DataServiceAdminStub;
import org.wso2.carbon.dataservices.ui.stub.admin.core.xsd.PaginatedTableInfo;
import org.wso2.ei.dataservices.integration.common.clients.utils.AuthenticateStubUtil;

public class DataServiceAdminClient {
    private static final Log log = LogFactory.getLog(DataServiceAdminClient.class);
    private final String serviceName = "DataServiceAdmin";
    private DataServiceAdminStub dataServiceAdminStub;

    public DataServiceAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "DataServiceAdmin";
        this.dataServiceAdminStub = new DataServiceAdminStub(endPoint);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.dataServiceAdminStub);
    }

    public DataServiceAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "DataServiceAdmin";
        this.dataServiceAdminStub = new DataServiceAdminStub(endPoint);
        AuthenticateStubUtil.authenticateStub(userName, password, (Stub)this.dataServiceAdminStub);
    }

    public String[] getCarbonDataSources() throws RemoteException {
        return this.dataServiceAdminStub.getCarbonDataSourceNames();
    }

    public void editDataService(String serviceName, String serviceHierachy, String dataServiceContent) throws RemoteException {
        this.dataServiceAdminStub.saveDataService(serviceName, serviceHierachy, dataServiceContent);
    }

    public String getDataServiceContent(String serviceName) throws RemoteException {
        String content = this.dataServiceAdminStub.getDataServiceContentAsString(serviceName);
        return content;
    }

    public void saveDataService(String serviceName, String serviceGroup, String serviceContents) throws AxisFault {
        try {
            this.dataServiceAdminStub.saveDataService(serviceName, serviceGroup, serviceContents);
        }
        catch (RemoteException e) {
            log.error((Object)("Error occurred while saving dataservice : " + serviceName), (Throwable)e);
            throw new AxisFault("Saving " + serviceName + " failed.", (Throwable)e);
        }
    }

    public String testJDBCConnection(String driverClass, String jdbcURL, String username, String password, String passwordAlias) throws AxisFault {
        String response = "";
        try {
            response = this.dataServiceAdminStub.testJDBCConnection(driverClass, jdbcURL, username, password, passwordAlias);
        }
        catch (RemoteException e) {
            throw new AxisFault("Error connecting to " + jdbcURL + ". Message from the service is : ", (Throwable)e);
        }
        return response;
    }

    public String testGSpreadConnection(String userName, String password, String visibility, String documentURL, String passwordAlias) throws AxisFault {
        String response = "";
        try {
            response = this.dataServiceAdminStub.testGSpreadConnection(userName, password, visibility, documentURL, passwordAlias);
        }
        catch (RemoteException e) {
            throw new AxisFault("Error connecting to " + documentURL + ". Message from the service is : ", (Throwable)e);
        }
        return response;
    }

    public String[] getOutputColumnNames(String query) throws Exception {
        return this.dataServiceAdminStub.getOutputColumnNames(query);
    }

    public String[] getInputMappingNames(String query) throws Exception {
        return this.dataServiceAdminStub.getInputMappingNames(query);
    }

    public PaginatedTableInfo getPaginatedTableInfo(int pageNumber, String datasourceId, String dbName, String[] schemas) throws Exception {
        return this.dataServiceAdminStub.getPaginatedTableInfo(pageNumber, datasourceId, dbName, schemas);
    }

    public PaginatedTableInfo getPaginatedSchemaInfo(int pageNumber, String datasourceId) throws Exception {
        return this.dataServiceAdminStub.getPaginatedSchemaInfo(pageNumber, datasourceId);
    }

    public String[] getTableInfo(String datasourceId, String dbName, String[] schemas) throws Exception {
        return this.dataServiceAdminStub.getTableList(datasourceId, dbName, schemas);
    }

    public String[] getdbSchemaList(String datasourceId) throws Exception {
        return this.dataServiceAdminStub.getdbSchemaList(datasourceId);
    }

    public String[] getDSServiceList(String dataSourceId, String dbName, String[] schemas, String[] tableNames, String serviceNamespace) {
        try {
            return this.dataServiceAdminStub.getDSServiceList(dataSourceId, dbName, schemas, tableNames, false, serviceNamespace);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDSService(String dataSourceId, String dbName, String[] schemas, String[] tableNames, String serviceName, String serviceNamespace) {
        try {
            return this.dataServiceAdminStub.getDSService(dataSourceId, dbName, schemas, tableNames, true, serviceName, serviceNamespace);
        }
        catch (Exception e) {
            return null;
        }
    }
}

