/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.dataservices.integration.common.clients;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.task.ui.stub.DSTaskAdminStub;
import org.wso2.carbon.dataservices.task.ui.stub.xsd.DSTaskInfo;
import org.wso2.ei.dataservices.integration.common.clients.DataServiceAdminClient;
import org.wso2.ei.dataservices.integration.common.clients.utils.AuthenticateStubUtil;

public class DataServiceTaskClient {
    private static final Log log = LogFactory.getLog(DataServiceAdminClient.class);
    private final String serviceName = "DSTaskAdmin";
    private DSTaskAdminStub dsTaskAdminStub;

    public DataServiceTaskClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "DSTaskAdmin";
        this.dsTaskAdminStub = new DSTaskAdminStub(endPoint);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.dsTaskAdminStub);
    }

    public DataServiceTaskClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "DSTaskAdmin";
        this.dsTaskAdminStub = new DSTaskAdminStub(endPoint);
        AuthenticateStubUtil.authenticateStub(userName, password, (Stub)this.dsTaskAdminStub);
    }

    public void deleteTask(String taskName) throws RemoteException {
        try {
            this.dsTaskAdminStub.deleteTask(taskName);
        }
        catch (RemoteException e) {
            log.error((Object)"Unable to delete the task", (Throwable)e);
            throw new RemoteException("Unable to delete the task", e);
        }
    }

    public String[] getAllTaskNames() throws RemoteException {
        try {
            return this.dsTaskAdminStub.getAllTaskNames();
        }
        catch (RemoteException e) {
            log.error((Object)"Unable to get all tasks", (Throwable)e);
            throw new RemoteException("Unable get all tasks", e);
        }
    }

    public void scheduleTask(DSTaskInfo dsTaskInfo) throws RemoteException {
        try {
            this.dsTaskAdminStub.scheduleTask(dsTaskInfo);
        }
        catch (RemoteException e) {
            log.error((Object)"Unable to add new task", (Throwable)e);
            throw new RemoteException("Unable to add new task", e);
        }
    }

    public boolean rescheduleTask(DSTaskInfo dsTaskInfo) throws RemoteException {
        try {
            return this.dsTaskAdminStub.rescheduleTask(dsTaskInfo);
        }
        catch (RemoteException e) {
            log.error((Object)"Unable to rescheduleTask", (Throwable)e);
            throw new RemoteException("Unable to rescheduleTask", e);
        }
    }
}

