/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.impl.CacheImpl;

public class CacheCleanupTask
implements Runnable {
    private static final Log log = LogFactory.getLog(CacheCleanupTask.class);
    private List<CacheImpl> caches = new CopyOnWriteArrayList<CacheImpl>();

    public void addCacheForMonitoring(CacheImpl cache) {
        this.caches.add(cache);
    }

    public void removeCacheFromMonitoring(CacheImpl cache) {
        this.caches.remove(cache);
    }

    @Override
    public synchronized void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cache expiry scheduler running...");
        }
        try {
            for (CacheImpl cache : this.caches) {
                cache.runCacheExpiry();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Cache expiry completed for cache " + cache.getName()));
            }
        }
        catch (IllegalStateException e) {
            log.debug((Object)"Error occurred while running CacheCleanupTask", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while running CacheCleanupTask", e);
        }
    }
}

