/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.GreenMail;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GreenMailServer {
    protected static Log log = LogFactory.getLog(GreenMailServer.class);
    private static GreenMail greenMail;
    private static GreenMailUser primaryUser;
    private static final String EMAIL_INBOX = "INBOX";
    private static final String EMAIL_TRASH = "Trash";
    private static final int WAIT_TIME_MS = 180000;
    private static final String USER_EMAIL = "wso2@localhost";
    private static final String USER_LOGIN = "wso2";
    private static final String USER_PW = "wso2";
    private static final String PROTOCOL_IMAP = "imap";
    private static final String PROTOCOL_POP3 = "pop3";
    private static final String BIND_ADDRESS = "127.0.0.1";

    public void startServer() {
        greenMail = new GreenMail();
        greenMail.start();
        primaryUser = greenMail.setUser(USER_EMAIL, "wso2", "wso2");
        log.info((Object)"GreenMail Server started and user added!");
    }

    public void stopServer() {
        greenMail.stop();
        log.info((Object)"GreenMail Server stopped!");
    }

    public static GreenMailUser addUser(String email, String login, String password) {
        GreenMailUser greenMailUser = greenMail.setUser(email, login, password);
        return greenMailUser;
    }

    public static GreenMailUser getPrimaryUser() {
        return primaryUser;
    }

    private static Store getConnection(GreenMailUser user, String protocol) throws MessagingException {
        int port;
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props);
        if (PROTOCOL_POP3.equals(protocol)) {
            port = 3110;
        } else if (PROTOCOL_IMAP.equals(protocol)) {
            port = 3143;
        } else {
            port = 3025;
            props.put("mail.smtp.auth", "true");
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.host", "localhost");
            props.put("mail.smtp.port", "3025");
        }
        URLName urlName = new URLName(protocol, BIND_ADDRESS, port, null, user.getLogin(), user.getPassword());
        Store store = session.getStore(urlName);
        store.connect();
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMailReceivedBySubject(String emailSubject, String folder, String protocol, GreenMailUser user) throws MessagingException {
        boolean emailReceived = false;
        try (Store store = GreenMailServer.getConnection(user, protocol);){
            Message[] messages;
            Folder mailFolder = store.getFolder(folder);
            mailFolder.open(2);
            AndTerm searchTerm = new AndTerm((SearchTerm)new SubjectTerm(emailSubject), (SearchTerm)new BodyTerm(emailSubject));
            for (Message message : messages = mailFolder.search((SearchTerm)searchTerm)) {
                if (!message.getSubject().contains(emailSubject)) continue;
                log.info((Object)("Found the Email with Subject : " + emailSubject));
                emailReceived = true;
                break;
            }
        }
        return emailReceived;
    }

    public static boolean checkEmailDeleted(String emailSubject, String protocol, GreenMailUser user) throws MessagingException, InterruptedException {
        boolean isEmailDeleted = false;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 180000L) {
            if (!GreenMailServer.isMailReceivedBySubject(emailSubject, EMAIL_INBOX, protocol, user)) {
                log.info((Object)"Email has been deleted successfully!");
                isEmailDeleted = true;
                break;
            }
            Thread.sleep(500L);
        }
        return isEmailDeleted;
    }

    public static boolean checkEmailDeleted(String emailSubject, String protocol) throws MessagingException, InterruptedException {
        return GreenMailServer.checkEmailDeleted(emailSubject, protocol, primaryUser);
    }

    public static boolean checkEmailMoved(String emailSubject, String protocol, GreenMailUser user) throws MessagingException, InterruptedException {
        boolean mailReceived = false;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 180000L) {
            if (GreenMailServer.isMailReceivedBySubject(emailSubject, EMAIL_TRASH, protocol, user)) {
                log.info((Object)("Found the moved email in mailbox : " + emailSubject));
                mailReceived = true;
                break;
            }
            Thread.sleep(500L);
        }
        return mailReceived;
    }

    public static boolean checkEmailMoved(String emailSubject, String protocol) throws MessagingException, InterruptedException {
        return GreenMailServer.checkEmailMoved(emailSubject, protocol, primaryUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllEmails(String protocol, GreenMailUser user) throws MessagingException {
        Folder inbox = null;
        Store store = GreenMailServer.getConnection(user, protocol);
        try {
            Message[] messages;
            inbox = store.getFolder(EMAIL_INBOX);
            inbox.open(2);
            for (Message message : messages = inbox.getMessages()) {
                message.setFlag(Flags.Flag.DELETED, true);
                log.info((Object)("Deleted email Subject : " + message.getSubject()));
            }
        }
        finally {
            if (inbox != null) {
                inbox.close(true);
            }
            if (store != null) {
                store.close();
            }
        }
    }

    public static void deleteAllEmails(String protocol) throws MessagingException {
        GreenMailServer.deleteAllEmails(protocol, primaryUser);
    }

    public static boolean isMailReceived(String protocol, GreenMailUser user, String subject) throws MessagingException {
        Message[] messages;
        Store store = GreenMailServer.getConnection(user, protocol);
        Folder folder = store.getFolder(EMAIL_INBOX);
        folder.open(1);
        boolean isReceived = false;
        for (Message message : messages = folder.getMessages()) {
            if (!message.getSubject().contains(subject)) continue;
            log.info((Object)("Found the Email with Subject : " + subject));
            isReceived = true;
            break;
        }
        return isReceived;
    }
}

