/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.utils.FileManager;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.esb.integration.common.extensions.carbonserver.CarbonServerExtension;

public class ServerConfigurationManager {
    private static final Log log = LogFactory.getLog(ServerConfigurationManager.class);
    private static final long TIME_OUT = 600000L;
    private static final String SERVER_STARTUP_MESSAGE = "WSO2 Micro Integrator started";
    private File originalConfig;
    private File backUpConfig;
    private int port;
    private String hostname;
    private String backEndUrl;
    private AutomationContext autoCtx;
    private String sessionCookie;
    private LoginLogoutClient loginLogoutClient;
    private List<ConfigData> configData = new ArrayList<ConfigData>();

    public ServerConfigurationManager(String productGroup, TestUserMode userMode) throws AutomationUtilException, XPathExpressionException, MalformedURLException {
        this.autoCtx = new AutomationContext(productGroup, userMode);
        this.loginLogoutClient = new LoginLogoutClient(this.autoCtx);
        this.backEndUrl = this.autoCtx.getContextUrls().getBackEndUrl();
        this.port = new URL(this.backEndUrl).getPort();
        this.hostname = new URL(this.backEndUrl).getHost();
    }

    public ServerConfigurationManager(AutomationContext autoCtx) throws AutomationUtilException, XPathExpressionException, MalformedURLException {
        this.loginLogoutClient = new LoginLogoutClient(autoCtx);
        this.autoCtx = autoCtx;
        this.backEndUrl = autoCtx.getContextUrls().getBackEndUrl();
        this.port = new URL(this.backEndUrl).getPort();
        this.hostname = new URL(this.backEndUrl).getHost();
    }

    public static String getCarbonHome() {
        return System.getProperty("carbon.home");
    }

    private void backupConfiguration(String fileName) throws IOException {
        String carbonHome = System.getProperty("carbon.home");
        String confDir = Paths.get(carbonHome, "conf").toString();
        String axis2Xml = "axis2";
        if (fileName.contains(axis2Xml)) {
            confDir = Paths.get(confDir, "axis2").toString();
        }
        this.originalConfig = Paths.get(confDir, fileName).toFile();
        this.backUpConfig = Paths.get(confDir, fileName + ".backup").toFile();
        Files.move(this.originalConfig.toPath(), this.backUpConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (this.originalConfig.exists()) {
            throw new IOException("Failed to rename file from " + this.originalConfig.getName() + "to" + this.backUpConfig.getName());
        }
        this.configData.add(new ConfigData(this.backUpConfig, this.originalConfig));
    }

    private void backupConfiguration(File file) throws IOException {
        this.originalConfig = file;
        this.backUpConfig = new File(file.getAbsolutePath() + ".backup");
        Files.move(this.originalConfig.toPath(), this.backUpConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (this.originalConfig.exists()) {
            throw new IOException("Failed to rename file from " + this.originalConfig.getName() + "to" + this.backUpConfig.getName());
        }
        this.configData.add(new ConfigData(this.backUpConfig, this.originalConfig));
    }

    public void applyConfigurationWithoutRestart(File sourceFile, File targetFile, boolean backup) throws IOException {
        FileChannel source = null;
        FileChannel destination = null;
        if (backup) {
            this.backupConfiguration(targetFile);
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(this.originalConfig).getChannel();
        } else {
            if (!targetFile.exists() && !targetFile.createNewFile()) {
                throw new IOException("File " + String.valueOf(targetFile) + "creation fails");
            }
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(targetFile).getChannel();
        }
        destination.transferFrom(source, 0L, source.size());
        if (source != null) {
            source.close();
        }
        if (destination != null) {
            destination.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfiguration(File sourceFile, File targetFile, boolean backupConfigFile, boolean restartServer) throws AutomationUtilException, IOException {
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            if (backupConfigFile) {
                this.backupConfiguration(targetFile);
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(this.originalConfig).getChannel();
            } else {
                if (!targetFile.exists() && !targetFile.createNewFile()) {
                    throw new IOException("File " + String.valueOf(targetFile) + "creation fails");
                }
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(targetFile).getChannel();
            }
            ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
            if (restartServer) {
                this.restartGracefully();
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void restoreToLastConfiguration() throws IOException, AutomationUtilException {
        this.restoreToLastConfiguration(true);
    }

    public void restoreToLastMIConfiguration() throws IOException, AutomationUtilException {
        CarbonServerExtension.shutdownServer();
        for (ConfigData data : this.configData) {
            Files.move(data.getBackupConfig().toPath(), data.getOriginalConfig().toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!data.getBackupConfig().exists()) continue;
            throw new IOException("File rename from " + String.valueOf(data.getBackupConfig()) + "to " + String.valueOf(data.getOriginalConfig()) + "fails");
        }
        CarbonServerExtension.startServer();
    }

    public void restoreToLastConfiguration(boolean isRestartRequired) throws AutomationUtilException, IOException {
        for (ConfigData data : this.configData) {
            Files.move(data.getBackupConfig().toPath(), data.getOriginalConfig().toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!data.getBackupConfig().exists()) continue;
            throw new IOException("File rename from " + String.valueOf(data.getBackupConfig()) + "to " + String.valueOf(data.getOriginalConfig()) + "fails");
        }
        if (isRestartRequired) {
            this.restartGracefully();
        }
    }

    public void applyConfiguration(File newConfig) throws AutomationUtilException, IOException {
        this.applyConfigurationUtil(newConfig, newConfig);
    }

    public void applyMIConfigurationWithRestart(File newConfig) throws AutomationUtilException, IOException {
        CarbonServerExtension.shutdownServer();
        this.applyConfigurationUtil(newConfig, newConfig);
        CarbonServerExtension.startServer();
    }

    public void applyMIConfiguration(File newConfig) throws IOException {
        this.appluConfigurationUtilUtil(newConfig, newConfig);
    }

    private String getProperty(File srcFile, String key) {
        String value = null;
        try (FileInputStream fis = new FileInputStream(srcFile);){
            Properties properties = new Properties();
            properties.load(fis);
            value = properties.getProperty(key);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception occurred with the message: " + e.getMessage()));
        }
        return value;
    }

    public void applyConfiguration(File sourceFile, File targetFile) throws AutomationUtilException, IOException {
        this.applyConfigurationUtil(sourceFile, targetFile);
    }

    private void applyConfigurationUtil(File sourceFile, File targetFile) throws IOException, AutomationUtilException {
        this.appluConfigurationUtilUtil(sourceFile, targetFile);
    }

    private void appluConfigurationUtilUtil(File sourceFile, File targetFile) throws IOException {
        this.backupConfiguration(targetFile.getName());
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(sourceFile), StandardCharsets.UTF_8);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.originalConfig), StandardCharsets.UTF_8);){
            int c;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
    }

    public void restartGracefully() throws AutomationUtilException {
    }

    public void restartMicroIntegrator() throws AutomationUtilException {
        CarbonServerExtension.restartServer();
    }

    public void restartMicroIntegrator(Map<String, String> commandMap) throws AutomationUtilException {
        CarbonServerExtension.restartServer(commandMap);
    }

    public void restartGracefully(long timeout) throws AutomationUtilException {
        this.restartGracefully();
    }

    private Process startProcess(String workingDirectory, String[] cmdArray) throws IOException {
        File commandDir = new File(workingDirectory);
        ProcessBuilder processBuilder = new ProcessBuilder(cmdArray);
        processBuilder.directory(commandDir);
        return processBuilder.start();
    }

    private void waitTill(BooleanSupplier predicate, int maxWaitTime, Duration timeUnit) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeUnit.toMillis();
        while (predicate.getAsBoolean() && System.currentTimeMillis() < endTime) {
            Thread.sleep(1000L);
        }
    }

    public void restartGracefully(String sessionCookie) throws AutomationUtilException {
        this.restartGracefully();
    }

    public void restartForcefully() throws AutomationUtilException {
        this.restartGracefully();
    }

    public void copyToComponentLib(File jar) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        String lib = Paths.get(carbonHome, "lib").toString();
        FileManager.copyJarFile((File)jar, (String)lib);
    }

    public void removeFromComponentLib(String fileName) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        String filePath = Paths.get(carbonHome, "lib", fileName).toString();
        FileManager.deleteFile((String)filePath);
        fileName = fileName.replace("-", "_");
        fileName = fileName.replace(".jar", "_1.0.0.jar");
        this.removeFromComponentDropins(fileName);
    }

    public void copyToCarbonapps(File CAPP) throws IOException {
        String carbonHome = System.getProperty("carbon.home");
        String path = Paths.get(carbonHome, "repository", "deployment", "server", "carbonapps").toString();
        FileManager.copyJarFile((File)CAPP, (String)path);
    }

    public void removeFromCarbonapps(String fileName) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        String filePath = Paths.get(carbonHome, "repository", "deployment", "server", "carbonapps", fileName).toString();
        FileManager.deleteFile((String)filePath);
    }

    public void removeFromComponentDropins(String fileName) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        URI filePath = Paths.get(carbonHome, "dropins", fileName).toUri();
        File file = Paths.get(filePath).toFile();
        if (file.exists()) {
            FileManager.deleteFile((String)file.getAbsolutePath());
        }
    }

    private static class ConfigData {
        private File backupConfig;
        private File originalConfig;

        public ConfigData(File backupConfig, File originalConfig) {
            this.backupConfig = backupConfig;
            this.originalConfig = originalConfig;
        }

        public File getBackupConfig() {
            return this.backupConfig;
        }

        public File getOriginalConfig() {
            return this.originalConfig;
        }
    }
}

