/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;

public class CPUMonitor {
    private static final Log log = LogFactory.getLog(CPUMonitor.class);
    private static final int CPU_THRESHOLD = 80;
    private static final String CPU_USAGE_FILE_PATH = System.getProperty("carbon.home") + File.separator + "cpu_usage.txt";
    private static final String CPU_LOGGER_SH_PATH = System.getProperty("carbon.home") + File.separator + "cpu_usage.sh";
    private static final String CARBON_PID_PATH = System.getProperty("carbon.home") + File.separator + "wso2carbon.pid";
    private Process process;

    public CPUMonitor() throws Exception {
        this.setup();
    }

    public void startLogging() throws IOException {
        log.info((Object)"Starting the CPU Monitor...");
        File file = new File(CPU_LOGGER_SH_PATH);
        boolean isScriptExecutable = file.setExecutable(true);
        if (!isScriptExecutable) {
            throw new IOException("Error setting execution permission to " + CPU_LOGGER_SH_PATH);
        }
        this.process = new ProcessBuilder(CPU_LOGGER_SH_PATH, CARBON_PID_PATH, CPU_USAGE_FILE_PATH).start();
        Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(30L, TimeUnit.SECONDS).until(this.isRunning());
    }

    private static int readCPUFromFile() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(CPU_USAGE_FILE_PATH));){
            String line = br.readLine();
            if (line != null) {
                int n = Integer.parseInt(line);
                return n;
            }
        }
        throw new IOException("Error reading the CPU Usage");
    }

    private Callable<Boolean> isRunning() {
        final File file = new File(CPU_USAGE_FILE_PATH);
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return file.exists();
            }
        };
    }

    public Callable<Boolean> isCPUSettled() {
        return new Callable<Boolean>(this){

            @Override
            public Boolean call() throws Exception {
                return CPUMonitor.readCPUFromFile() < 80;
            }
        };
    }

    private void setup() throws IOException {
        log.info((Object)"Copying script file to read CPU usage...");
        URL inputUrl = this.getClass().getResource("/helper/cpu_usage.sh");
        File dest = new File(CPU_LOGGER_SH_PATH);
        FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
    }

    public void stop() {
        this.process.destroy();
    }
}

