/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.flow.statistics.publishing.PublishingPayload;
import org.wso2.esb.integration.common.utils.common.TestConfigurationProvider;

public class ESBTestCaseUtils {
    private static final String PROXY = "proxy";
    private static final String LOCAL_ENTRY = "localEntry";
    private static final String ENDPOINT = "endpoint";
    private static final String SEQUENCE = "sequence";
    private static final String MESSAGE_STORE = "messageStore";
    private static final String MESSAGE_PROCESSOR = "messageProcessor";
    private static final String TEMPLATE = "template";
    private static final String API = "api";
    private static final String PRIORITY_EXECUTOR = "priorityExecutor";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String TASK = "task";
    private static final String INBOUND_ENDPOINT = "inboundEndpoint";
    private static int SERVICE_DEPLOYMENT_DELAY = TestConfigurationProvider.getServiceDeploymentDelay();
    protected Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String sourceUri, String destUri) throws IOException {
        File sourceFile = new File(sourceUri);
        File destFile = new File(destUri);
        if (destFile.exists()) {
            destFile.delete();
        }
        destFile.createNewFile();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(sourceFile);
            fileOutputStream = new FileOutputStream(destFile);
            FileChannel source = fileInputStream.getChannel();
            FileChannel destination = fileOutputStream.getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    public static Map<String, Object> decompress(String str) {
        ByteArrayInputStream byteInputStream = null;
        GZIPInputStream gzipInputStream = null;
        try {
            ThreadLocal<Kryo> kryoTL = new ThreadLocal<Kryo>(){

                @Override
                protected Kryo initialValue() {
                    Kryo kryo = new Kryo();
                    kryo.register(HashMap.class, 111);
                    kryo.register(ArrayList.class, 222);
                    kryo.register(PublishingPayload.class, 333);
                    return kryo;
                }
            };
            byteInputStream = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)str));
            gzipInputStream = new GZIPInputStream(byteInputStream);
            byte[] unzippedBytes = IOUtils.toByteArray((InputStream)gzipInputStream);
            Input input = new Input(unzippedBytes);
            Map map = (Map)((Kryo)kryoTL.get()).readObjectOrNull(input, HashMap.class);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("Error occured while decompressing events string: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteInputStream != null) {
                    byteInputStream.close();
                }
                if (gzipInputStream != null) {
                    gzipInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement loadResource(String path) throws FileNotFoundException, XMLStreamException {
        OMElement documentElement = null;
        FileInputStream inputStream = null;
        XMLStreamReader parser = null;
        StAXOMBuilder builder = null;
        path = TestConfigurationProvider.getResourceLocation() + (String)path;
        File file = new File((String)path);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                builder = new StAXOMBuilder(parser);
                documentElement = builder.getDocumentElement().cloneOMElement();
            }
            finally {
                if (builder != null) {
                    builder.close();
                }
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new FileNotFoundException("File Not Exist at " + (String)path);
        return documentElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement loadESBSampleConfiguration(int number) throws Exception {
        String filePath = Paths.get(TestConfigurationProvider.getResourceLocation("ESB"), "samples", "synapse_sample_" + number + ".xml").toString();
        File configFile = new File(filePath);
        FileInputStream inputStream = null;
        XMLStreamReader parser = null;
        StAXOMBuilder builder = null;
        OMElement documentElement = null;
        try {
            inputStream = new FileInputStream(configFile.getAbsolutePath());
            parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            builder = new StAXOMBuilder(parser);
            documentElement = builder.getDocumentElement().cloneOMElement();
        }
        finally {
            if (builder != null) {
                builder.close();
            }
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return documentElement;
    }

    public void updateESBConfiguration(OMElement synapseConfig, String backendURL, String sessionCookie) throws Exception {
    }

    public void addProxyService(String backEndUrl, String sessionCookie, OMElement proxyConfig) throws Exception {
    }

    public void addInboundEndpointFromParams(String backEndUrl, String sessionCookie, OMElement inboundEndpoint) throws Exception {
    }

    public void updateInboundEndpoint(String backEndUrl, String sessionCookie, OMElement inboundEndpoint) throws Exception {
    }

    public boolean isFileEmpty(String fullPath) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fullPath));
            if (br.readLine() == null) {
                return true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.info((Object)("Synapse config file cannot be found in " + fullPath + " copying Backup Config to the location."));
            return true;
        }
        catch (IOException ioException) {
            this.log.info((Object)("Couldn't read the synapse config from the location " + fullPath));
        }
        return false;
    }
}

