/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.synapse.SynapseException;
import org.awaitility.Awaitility;
import org.json.JSONObject;
import org.wso2.carbon.automation.engine.configurations.UrlGenerationUtil;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.beans.ContextUrls;
import org.wso2.carbon.automation.engine.context.beans.Instance;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.esb.integration.common.utils.ESBTestCaseUtils;
import org.wso2.esb.integration.common.utils.EndpointGenerator;
import org.wso2.esb.integration.common.utils.clients.SimpleHttpClient;
import org.wso2.esb.integration.common.utils.clients.stockquoteclient.StockQuoteClient;

public abstract class ESBIntegrationTest {
    private static final String synapsePathFormBaseUri = File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "synapse-configs" + File.separator + "default" + File.separator + "synapse.xml";
    protected Log log = LogFactory.getLog(this.getClass());
    protected StockQuoteClient axis2Client;
    protected ContextUrls contextUrls = new ContextUrls();
    protected String sessionCookie;
    protected OMElement synapseConfiguration = null;
    protected ESBTestCaseUtils esbUtils;
    protected AutomationContext context;
    private List<String> proxyServicesList = null;
    private List<String> sequencesList = null;
    private List<String> endpointsList = null;
    private List<String> localEntryList = null;
    private List<String> messageProcessorsList = null;
    private List<String> messageStoresList = null;
    private List<String> sequenceTemplateList = null;
    private List<String> apiList = null;
    private List<String> priorityExecutorList = null;
    private List<String[]> scheduledTaskList = null;
    private List<String> inboundEndpointList = null;
    public static final int DEFAULT_INTERNAL_API_HTTPS_PORT = 9154;
    protected String hostName = null;
    protected int portOffset;
    protected final int DEFAULT_TIMEOUT = 60;
    protected boolean isManagementApiAvailable = false;
    private final String SERVER_DEPLOYMENT_DIR = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "synapse-configs" + File.separator + "default" + File.separator;
    protected final String PROXY_DIRECTORY = this.SERVER_DEPLOYMENT_DIR + File.separator + "proxy-services";

    protected void init() throws Exception {
        this.axis2Client = new StockQuoteClient();
        this.context = new AutomationContext();
        this.contextUrls = this.context.getContextUrls();
        this.esbUtils = new ESBTestCaseUtils();
        this.hostName = UrlGenerationUtil.getManagerHost((Instance)this.context.getInstance());
        this.portOffset = Integer.parseInt(System.getProperty("port.offset"));
        this.isManagementApiAvailable = false;
    }

    protected void initLight() {
        this.hostName = "localhost";
        this.portOffset = Integer.parseInt(System.getProperty("port.offset"));
        this.isManagementApiAvailable = false;
    }

    public String getHostname() {
        return this.hostName;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    protected void cleanup() throws Exception {
    }

    protected String getMainSequenceURL() {
        return this.getMainSequenceURL(false);
    }

    protected String getMainSequenceURL(boolean https) {
        Object mainSequenceUrl = this.contextUrls.getServiceUrl();
        if (https) {
            mainSequenceUrl = this.contextUrls.getSecureServiceUrl();
        }
        if (((String)mainSequenceUrl).endsWith("/services")) {
            mainSequenceUrl = ((String)mainSequenceUrl).replace("/services", "");
        }
        if (!((String)mainSequenceUrl).endsWith("/")) {
            mainSequenceUrl = (String)mainSequenceUrl + "/";
        }
        return mainSequenceUrl;
    }

    protected String getProxyServiceURLHttp(String proxyServiceName) {
        return this.contextUrls.getServiceUrl() + "/" + proxyServiceName;
    }

    protected String getApiInvocationURL(String apiName) {
        return this.getMainSequenceURL() + apiName;
    }

    protected String getApiInvocationURLHttps(String apiName) {
        return this.getMainSequenceURL(true) + apiName;
    }

    protected String getProxyServiceURLHttps(String proxyServiceName) {
        return this.contextUrls.getSecureServiceUrl() + "/" + proxyServiceName;
    }

    protected void loadSampleESBConfiguration(int sampleNo) throws Exception {
        OMElement synapseSample = this.esbUtils.loadESBSampleConfiguration(sampleNo);
    }

    protected OMElement loadSampleESBConfigurationWithoutApply(int sampleNo) throws Exception {
        return this.esbUtils.loadESBSampleConfiguration(sampleNo);
    }

    protected void loadESBConfigurationFromClasspath(String relativeFilePath) throws Exception {
    }

    protected void updateESBConfiguration(OMElement synapseConfig) throws Exception {
    }

    protected void updateInboundEndpoint(OMElement inboundEndpoint) throws Exception {
        try {
            this.esbUtils.updateInboundEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpoint);
        }
        catch (Exception e) {
            throw new Exception("Error when adding InboundEndpoint", e);
        }
    }

    protected void updateESBRegistry(String resourcePath) throws Exception {
    }

    protected String getESBResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "ESB";
    }

    protected String getBackEndServiceUrl(String serviceName) throws XPathExpressionException {
        return EndpointGenerator.getBackEndServiceEndpointUrl(serviceName);
    }

    protected void verifyProxyServiceExistence(String proxyServiceName) throws RemoteException {
    }

    protected boolean checkCarbonAppExistence(String carbonAppName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("applications");
        return response.contains(carbonAppName);
    }

    protected boolean checkApiExistence(String apiName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("apis");
        return response.contains(apiName);
    }

    protected boolean checkEndpointExistence(String endpoinName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("endpoints");
        return response.contains(endpoinName);
    }

    protected boolean checkInboundEndpointExistence(String inboundEndpointName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("inbound-endpoints");
        return response.contains(inboundEndpointName);
    }

    protected int getNoOfArtifacts(String artifactType) throws IOException {
        int count = 0;
        String response = this.retrieveArtifactUsingManagementApi(artifactType);
        JSONObject jsonObject = new JSONObject(response);
        if (jsonObject.has("count")) {
            count = jsonObject.getInt("count");
        }
        return count;
    }

    protected boolean checkProxyServiceExistence(String proxyServiceName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("proxy-services");
        return response.contains(proxyServiceName);
    }

    protected String deployCarbonApplication(File carbonApp) throws IOException {
        return this.deployCarbonApplicationUsingManagementApi("applications", carbonApp);
    }

    protected String deployCarbonApplication(File carbonApp, Map<String, String> header) throws IOException {
        return this.deployCarbonApplicationUsingManagementApi("applications", carbonApp, header);
    }

    protected String unDeployCarbonApplication(String carbonApp) throws IOException {
        return this.unDeployCarbonApplicationUsingManagementApi("applications", carbonApp);
    }

    private boolean checkTaskExistence(String taskName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("tasks");
        return response.contains(taskName);
    }

    protected boolean isArtifactDeployed(BooleanSupplier methodToCheck, int maxWaitTime) throws InterruptedException {
        for (int i = 0; i < maxWaitTime; ++i) {
            if (methodToCheck.getAsBoolean()) {
                return true;
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        return false;
    }

    protected boolean checkSequenceExistence(String sequenceName) {
        String response;
        try {
            response = this.retrieveArtifactUsingManagementApi("sequences");
        }
        catch (IOException e) {
            this.log.error((Object)e);
            return false;
        }
        return response.contains(sequenceName);
    }

    protected boolean checkLocalEntryExistence(String localEntryName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("local-entries");
        return response.contains(localEntryName);
    }

    protected boolean checkMessageStoreExistence(String messageStoreName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("message-stores");
        return response.contains(messageStoreName);
    }

    protected boolean checkMessageProcessorExistence(String messageProcessorName) {
        String response;
        try {
            response = this.retrieveArtifactUsingManagementApi("message-processors");
        }
        catch (IOException e) {
            this.log.error((Object)e);
            return false;
        }
        return response.contains(messageProcessorName);
    }

    private String retrieveArtifactUsingManagementApi(String artifactType) throws IOException {
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        SimpleHttpClient client = new SimpleHttpClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        String endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/" + artifactType;
        HttpResponse response = client.doGet(endpoint, headers);
        return client.getResponsePayload(response);
    }

    private String deployCarbonApplicationUsingManagementApi(String artifactType, File cabonApp) throws IOException {
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        SimpleHttpClient client = new SimpleHttpClient();
        String endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/" + artifactType;
        HttpResponse response = client.doPostWithMultipart(endpoint, cabonApp);
        return client.getResponsePayload(response);
    }

    private String deployCarbonApplicationUsingManagementApi(String artifactType, File cabonApp, Map<String, String> header) throws IOException {
        String endpoint;
        SimpleHttpClient client;
        HttpResponse response;
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        if ((response = (client = new SimpleHttpClient()).doPostWithMultipart(endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/" + artifactType, cabonApp, header)).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Failed to deploy Carbon Application. HTTP error code: " + response.getStatusLine().getStatusCode() + ". Response: " + client.getResponsePayload(response));
        }
        return client.getResponsePayload(response);
    }

    private String unDeployCarbonApplicationUsingManagementApi(String artifactType, String cabonApp) throws IOException {
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        SimpleHttpClient client = new SimpleHttpClient();
        String endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/" + artifactType + "/" + cabonApp;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        HttpResponse response = client.doDelete(endpoint, headers);
        return client.getResponsePayload(response);
    }

    public Callable<Boolean> isManagementApiAvailable() {
        return () -> {
            Boolean bl;
            Socket s = new Socket(this.hostName, 9154 + this.portOffset);
            try {
                this.isManagementApiAvailable = true;
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error while opening socket for port " + (9154 + this.portOffset)), (Throwable)e);
                    return false;
                }
            }
            s.close();
            return bl;
        };
    }

    protected OMElement replaceEndpoints(String relativePathToConfigFile, String serviceName, String port) throws XMLStreamException, FileNotFoundException, XPathExpressionException {
        String config = this.esbUtils.loadResource(relativePathToConfigFile).toString();
        config = config.replace("http://localhost:" + port + "/services/" + serviceName, this.getBackEndServiceUrl(serviceName));
        return AXIOMUtil.stringToOM((String)config);
    }

    private String readInputStreamAsString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    protected String getSessionCookie() {
        return this.sessionCookie;
    }

    protected String[] getUserRole() {
        return new String[]{"admin"};
    }

    protected void reloadSessionCookie() throws Exception {
    }

    public void configureHTTPWireLogs(String logLevel) {
        String loggerName = "synapse-transport-http-wire";
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        try {
            SimpleHttpClient client = new SimpleHttpClient();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            String endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/logging";
            JSONObject payload = new JSONObject();
            payload.put("loggerName", (Object)loggerName);
            payload.put("loggingLevel", (Object)logLevel);
            client.doPatch(endpoint, headers, payload.toString(), "application/json");
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isLogsConfigured(endpoint, loggerName, logLevel));
        }
        catch (IOException e) {
            throw new SynapseException("Error updating the log-level of synapse-transport-http-wire logger", (Throwable)e);
        }
    }

    private Callable<Boolean> isLogsConfigured(String endpoint, String loggerName, String logLevel) {
        return () -> this.isLogConfigured(endpoint + "?loggerName=" + loggerName, logLevel);
    }

    private boolean isLogConfigured(String endpoint, String logLevel) {
        try {
            SimpleHttpClient client = new SimpleHttpClient();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            HttpResponse response = client.doGet(endpoint, headers);
            String responsePayload = client.getResponsePayload(response);
            if (response.getStatusLine().getStatusCode() != 200) {
                return false;
            }
            JSONObject jsonResponse = new JSONObject(responsePayload);
            return jsonResponse.get("level").toString().equals(logLevel);
        }
        catch (IOException e) {
            this.log.error((Object)"Error occurred while checking the log level", (Throwable)e);
            return false;
        }
    }

    private void copyArtifactToDeploymentDirectory(String sourceArtifactPath, String artifactName, String deploymentDirectory) throws IOException {
        Files.copy(new File(sourceArtifactPath + File.separator + artifactName + ".xml").toPath(), new File(deploymentDirectory + File.separator + artifactName + ".xml").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void deleteArtifactFromDeploymentDirectory(String artifactName, String deploymentDirectory) throws IOException {
        Files.delete(new File(deploymentDirectory + File.separator + artifactName).toPath());
    }

    protected void undeployProxyService(String name) throws IOException {
        this.deleteArtifactFromDeploymentDirectory(name + ".xml", this.PROXY_DIRECTORY);
    }

    protected void deployProxyService(String name, String resourcePath) throws IOException {
        this.copyArtifactToDeploymentDirectory(resourcePath, name, this.PROXY_DIRECTORY);
    }
}

