/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients.rabbitmqclient;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class RabbitMQConsumerClient {
    private ConnectionFactory factory = new ConnectionFactory();
    private Connection connection = null;
    private Channel channel = null;
    private String routeKey;

    public RabbitMQConsumerClient(String host) {
        this.factory.setHost(host);
    }

    public void declareAndConnect(String exchangeName, String routeKey) throws IOException {
        try {
            this.connection = this.factory.newConnection();
            this.channel = this.connection.createChannel();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        this.routeKey = routeKey;
        try {
            this.channel.exchangeDeclarePassive(exchangeName);
        }
        catch (IOException e) {
            if (!this.channel.isOpen()) {
                this.channel = this.connection.createChannel();
            }
            this.channel.exchangeDeclare(exchangeName, "direct", true);
        }
        try {
            this.channel.queueDeclarePassive(routeKey);
        }
        catch (IOException e) {
            if (!this.channel.isOpen()) {
                this.channel = this.connection.createChannel();
            }
            this.channel.queueDeclare(routeKey, true, false, false, null);
        }
        this.channel.queueBind(routeKey, exchangeName, routeKey);
    }

    public List<String> popAllMessages() throws IOException, InterruptedException {
        GetResponse response;
        ArrayList<String> messages = new ArrayList<String>();
        while ((response = this.channel.basicGet(this.routeKey, true)) != null) {
            messages.add(new String(response.getBody()));
        }
        return messages;
    }

    public void disconnect() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        try {
            this.connection.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

