/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.esb.integration.common.extensions.carbonserver.TestServerManager;

public class MultipleServersManager {
    private static final Log log = LogFactory.getLog(MultipleServersManager.class);
    private Map<String, TestServerManager> servers = new HashMap<String, TestServerManager>();
    private String deploymentDirectory = null;
    private String registryDirectory = null;

    public void startServers(TestServerManager ... serverManagers) throws AutomationFrameworkException {
        int noOfServers = serverManagers.length;
        for (int index = 0; index < noOfServers; ++index) {
            log.info((Object)("============================== Configuring server " + (this.servers.size() + 1) + " =============================="));
            TestServerManager testServerManager = serverManagers[index];
            try {
                String carbonHome = testServerManager.startServer();
                this.servers.put(carbonHome, testServerManager);
                continue;
            }
            catch (Exception ex) {
                throw new AutomationFrameworkException((Throwable)ex);
            }
        }
    }

    public void startServersWithDepSync(boolean mountRegistry, TestServerManager ... serverManagers) throws AutomationFrameworkException {
        int noOfServers = serverManagers.length;
        for (int index = 0; index < noOfServers; ++index) {
            log.info((Object)("============================== Configuring server " + (this.servers.size() + 1) + " =============================="));
            TestServerManager testServerManager = serverManagers[index];
            try {
                String carbonHome;
                if (this.deploymentDirectory == null) {
                    carbonHome = testServerManager.startServer();
                    this.deploymentDirectory = String.join((CharSequence)File.separator, carbonHome, "repository", "deployment");
                    if (mountRegistry) {
                        this.registryDirectory = String.join((CharSequence)File.separator, carbonHome, "registry");
                    }
                } else {
                    carbonHome = testServerManager.startServer(this.deploymentDirectory, this.registryDirectory);
                }
                this.servers.put(carbonHome, testServerManager);
                continue;
            }
            catch (Exception ex) {
                throw new AutomationFrameworkException((Throwable)ex);
            }
        }
    }

    public String getDeploymentDirectory() {
        return this.deploymentDirectory;
    }

    public void stopAllServers() throws AutomationFrameworkException {
        for (TestServerManager serverUtils : this.servers.values()) {
            serverUtils.stopServer();
        }
    }
}

