/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.template;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.templates.stub.types.TemplateAdminServiceStub;
import org.wso2.carbon.mediation.templates.stub.types.common.TemplateInfo;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class SequenceTemplateAdminServiceClient {
    private static final Log log = LogFactory.getLog(SequenceTemplateAdminServiceClient.class);
    private final String serviceName = "TemplateAdminService";
    private TemplateAdminServiceStub templateAdminStub;

    public SequenceTemplateAdminServiceClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "TemplateAdminService";
        this.templateAdminStub = new TemplateAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.templateAdminStub);
    }

    public SequenceTemplateAdminServiceClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "TemplateAdminService";
        this.templateAdminStub = new TemplateAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.templateAdminStub);
    }

    public void addSequenceTemplate(OMElement template) throws RemoteException {
        this.templateAdminStub.addTemplate(template);
    }

    public void addSequenceTemplate(DataHandler dh) throws IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement template = builder.getDocumentElement();
        this.templateAdminStub.addTemplate(template);
    }

    public void addDynamicSequenceTemplate(String key, OMElement template) throws RemoteException {
        this.templateAdminStub.addDynamicTemplate(key, template);
    }

    public void addDynamicSequenceTemplate(String key, DataHandler dh) throws IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement template = builder.getDocumentElement();
        this.templateAdminStub.addDynamicTemplate(key, template);
    }

    public void deleteTemplate(String templateName) throws RemoteException {
        this.templateAdminStub.deleteTemplate(templateName);
    }

    public void deleteDynamicTemplate(String key) throws RemoteException {
        this.templateAdminStub.deleteDynamicTemplate(key);
    }

    public int getTemplatesCount() throws RemoteException {
        return this.templateAdminStub.getTemplatesCount();
    }

    public int getDynamicTemplateCount() throws RemoteException {
        return this.templateAdminStub.getDynamicTemplateCount();
    }

    public String[] getSequenceTemplates() throws RemoteException {
        TemplateInfo[] info = this.templateAdminStub.getTemplates(0, 200);
        if (info == null || info.length == 0) {
            return null;
        }
        String[] templates = new String[info.length];
        int i = 0;
        for (TemplateInfo tmpInfo : info) {
            templates[i++] = tmpInfo.getName();
        }
        return templates;
    }
}

