/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.service.mgt;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.service.mgt.stub.ServiceAdminException;
import org.wso2.carbon.service.mgt.stub.ServiceAdminStub;
import org.wso2.carbon.service.mgt.stub.types.carbon.FaultyService;
import org.wso2.carbon.service.mgt.stub.types.carbon.FaultyServicesWrapper;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceMetaData;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceMetaDataWrapper;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class ServiceAdminClient {
    private static final Log log = LogFactory.getLog(ServiceAdminClient.class);
    private final String serviceName = "ServiceAdmin";
    private ServiceAdminStub serviceAdminStub;

    public ServiceAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "ServiceAdmin";
        this.serviceAdminStub = new ServiceAdminStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.serviceAdminStub);
    }

    public ServiceAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "ServiceAdmin";
        this.serviceAdminStub = new ServiceAdminStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.serviceAdminStub);
    }

    public void deleteService(String[] serviceGroup) throws RemoteException {
        this.serviceAdminStub.deleteServiceGroups(serviceGroup);
    }

    public boolean deleteFaultyService(String archiveName) throws RemoteException {
        try {
            return this.serviceAdminStub.deleteFaultyServiceGroup(archiveName);
        }
        catch (RemoteException e) {
            log.error((Object)"Faulty service deletion fails", (Throwable)e);
            throw new RemoteException("Faulty service deletion fails", e);
        }
    }

    public boolean deleteFaultyServiceByServiceName(String serviceName) throws RemoteException {
        try {
            return this.serviceAdminStub.deleteFaultyServiceGroup(this.getFaultyData(serviceName).getArtifact());
        }
        catch (RemoteException e) {
            log.error((Object)"Faulty service deletion fails", (Throwable)e);
            throw new RemoteException("Faulty service deletion fails", e);
        }
    }

    public void deleteAllNonAdminServiceGroups() throws RemoteException {
        this.serviceAdminStub.deleteAllNonAdminServiceGroups();
    }

    public ServiceMetaDataWrapper listServices(String serviceName) throws RemoteException {
        ServiceMetaDataWrapper serviceMetaDataWrapper = this.serviceAdminStub.listServices("ALL", serviceName, 0);
        this.serviceAdminStub.getFaultyServiceArchives(0);
        return serviceMetaDataWrapper;
    }

    public ServiceMetaDataWrapper listServices(String serviceName, String filerType) throws RemoteException {
        ServiceMetaDataWrapper serviceMetaDataWrapper = this.serviceAdminStub.listServices(filerType, serviceName, 0);
        this.serviceAdminStub.getFaultyServiceArchives(0);
        return serviceMetaDataWrapper;
    }

    public FaultyServicesWrapper getFaultyServiceArchives(int pageNumber) throws RemoteException {
        FaultyServicesWrapper faultyServicesWrapper;
        try {
            faultyServicesWrapper = this.serviceAdminStub.getFaultyServiceArchives(pageNumber);
        }
        catch (RemoteException e) {
            log.error((Object)"Unable to get faulty service Archives", (Throwable)e);
            throw new RemoteException("Unable to get faulty service Archives", e);
        }
        return faultyServicesWrapper;
    }

    public FaultyServicesWrapper listFaultyServices() throws RemoteException {
        FaultyServicesWrapper faultyServicesWrapper = this.serviceAdminStub.getFaultyServiceArchives(0);
        return faultyServicesWrapper;
    }

    public boolean isServiceExists(String serviceName) throws RemoteException {
        boolean serviceState = false;
        ServiceMetaDataWrapper serviceMetaDataWrapper = this.listServices(serviceName);
        ServiceMetaData[] serviceMetaDataList = serviceMetaDataWrapper.getServices();
        if (serviceMetaDataList == null || serviceMetaDataList.length == 0) {
            serviceState = false;
        } else {
            for (ServiceMetaData serviceData : serviceMetaDataList) {
                if (serviceData == null || !serviceData.getName().equalsIgnoreCase(serviceName)) continue;
                return true;
            }
        }
        return serviceState;
    }

    public void deleteMatchingServiceByGroup(String serviceFileName) throws RemoteException {
        String matchingServiceName = this.getMatchingServiceName(serviceFileName);
        if (matchingServiceName != null) {
            String[] serviceGroup = new String[]{this.getServiceGroup(matchingServiceName)};
            log.info((Object)("Service group name " + serviceGroup[0]));
            this.serviceAdminStub.deleteServiceGroups(serviceGroup);
        } else {
            log.error((Object)"Service group name cannot be null");
        }
    }

    public String deleteAllServicesByType(String type) throws RemoteException {
        ServiceMetaData[] serviceMetaDataList;
        ServiceMetaDataWrapper serviceMetaDataWrapper = this.serviceAdminStub.listServices("ALL", null, 0);
        if (serviceMetaDataWrapper != null && (serviceMetaDataList = serviceMetaDataWrapper.getServices()) != null && serviceMetaDataList.length > 0) {
            for (ServiceMetaData serviceData : serviceMetaDataList) {
                if (!serviceData.getServiceType().equalsIgnoreCase(type)) continue;
                String[] serviceGroup = new String[]{serviceData.getServiceGroupName()};
                this.deleteService(serviceGroup);
            }
        }
        return null;
    }

    public String getMatchingServiceName(String serviceFileName) throws RemoteException {
        ServiceMetaData[] serviceMetaDataList;
        ServiceMetaDataWrapper serviceMetaDataWrapper = this.serviceAdminStub.listServices("ALL", serviceFileName, 0);
        if (serviceMetaDataWrapper != null && (serviceMetaDataList = serviceMetaDataWrapper.getServices()) != null && serviceMetaDataList.length > 0) {
            for (ServiceMetaData serviceData : serviceMetaDataList) {
                if (serviceData == null || !serviceData.getName().contains(serviceFileName)) continue;
                return serviceData.getName();
            }
        }
        return null;
    }

    public String getServiceGroup(String serviceName) throws RemoteException {
        ServiceMetaDataWrapper serviceMetaDataWrapper = this.listServices(serviceName);
        ServiceMetaData[] serviceMetaDataList = serviceMetaDataWrapper.getServices();
        if (serviceMetaDataList != null && serviceMetaDataList.length > 0) {
            for (ServiceMetaData serviceData : serviceMetaDataList) {
                if (serviceData == null || !serviceData.getName().equalsIgnoreCase(serviceName)) continue;
                return serviceData.getServiceGroupName();
            }
        }
        return null;
    }

    public boolean isServiceFaulty(String serviceName) throws RemoteException {
        boolean serviceState = false;
        FaultyServicesWrapper faultyServicesWrapper = this.listFaultyServices();
        if (faultyServicesWrapper != null) {
            FaultyService[] faultyServiceList = faultyServicesWrapper.getFaultyServices();
            if (faultyServiceList == null || faultyServiceList.length == 0) {
                serviceState = false;
            } else {
                for (FaultyService faultyServiceData : faultyServiceList) {
                    if (faultyServiceData == null || !faultyServiceData.getServiceName().equalsIgnoreCase(serviceName)) continue;
                    return true;
                }
            }
        }
        return serviceState;
    }

    public FaultyService getFaultyData(String serviceName) throws RemoteException {
        FaultyService faultyService = null;
        FaultyServicesWrapper faultyServicesWrapper = this.listFaultyServices();
        if (faultyServicesWrapper != null) {
            FaultyService[] faultyServiceList = faultyServicesWrapper.getFaultyServices();
            if (faultyServiceList == null || faultyServiceList.length == 0) {
                throw new RuntimeException("Service not found in faulty service list");
            }
            for (FaultyService faultyServiceData : faultyServiceList) {
                if (faultyServiceData == null || !faultyServiceData.getServiceName().equalsIgnoreCase(serviceName)) continue;
                faultyService = faultyServiceData;
            }
        }
        if (faultyService == null) {
            throw new RuntimeException("Service not found in faulty service list " + faultyService);
        }
        return faultyService;
    }

    public ServiceMetaData getServicesData(String serviceName) throws ServiceAdminException, RemoteException {
        return this.serviceAdminStub.getServiceData(serviceName);
    }

    public void startService(String serviceName) throws ServiceAdminException, RemoteException {
        this.serviceAdminStub.startService(serviceName);
        log.info((Object)"Service Started");
    }

    public void stopService(String serviceName) throws ServiceAdminException, RemoteException {
        this.serviceAdminStub.stopService(serviceName);
        log.info((Object)"Service Stopped");
    }

    public String[] getExposedTransports(String serviceName) throws ServiceAdminException, RemoteException {
        return this.serviceAdminStub.getExposedTransports(serviceName);
    }
}

