/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.registry;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.activities.stub.ActivityAdminServiceStub;
import org.wso2.carbon.registry.activities.stub.RegistryExceptionException;
import org.wso2.carbon.registry.activities.stub.beans.xsd.ActivityBean;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class ActivityAdminServiceClient {
    public static final String FILTER_ALL = "All";
    public static final String FILTER_ASSOCIATE_ASPECT = "Associate Aspect";
    public static final String FILTER_RESOURCE_ADDED = "Resource Add";
    public static final String FILTER_RESOURCE_UPDATE = "Resource Update";
    private static final Log log = LogFactory.getLog(ActivityAdminServiceClient.class);
    private final String serviceName = "ActivityAdminService";
    private ActivityAdminServiceStub activityAdminServiceStub;
    private String endPoint;

    public ActivityAdminServiceClient(String backEndUrl, String sessionCookie) throws AxisFault {
        this.endPoint = backEndUrl + "ActivityAdminService";
        try {
            this.activityAdminServiceStub = new ActivityAdminServiceStub(this.endPoint);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("activityAdminServiceStub Initialization fail " + axisFault.getMessage()));
            throw new AxisFault("activityAdminServiceStub Initialization fail ", (Throwable)axisFault);
        }
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.activityAdminServiceStub);
    }

    public ActivityAdminServiceClient(String backEndUrl, String userName, String password) throws AxisFault {
        this.endPoint = backEndUrl + "ActivityAdminService";
        try {
            this.activityAdminServiceStub = new ActivityAdminServiceStub(this.endPoint);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("activityAdminServiceStub Initialization fail " + axisFault.getMessage()));
            throw new AxisFault("activityAdminServiceStub Initialization fail ", (Throwable)axisFault);
        }
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.activityAdminServiceStub);
    }

    public ActivityBean getActivities(String sessionCookie, String userName, String resourcePath, String fromDate, String toDate, String filter, int page) throws RemoteException, RegistryExceptionException {
        try {
            return this.activityAdminServiceStub.getActivities(userName, resourcePath, fromDate, toDate, filter, "" + page, sessionCookie);
        }
        catch (RemoteException e) {
            String msg = "Fails to get activities";
            log.error((Object)(msg + " " + e.getMessage()));
            throw new RemoteException(msg, e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Fails to get activities";
            log.error((Object)(msg + " " + e.getMessage()));
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.activityAdminServiceStub._getServiceClient().getServiceContext().getConfigurationContext();
    }
}

