/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.aar.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.aarservices.stub.ExceptionException;
import org.wso2.carbon.aarservices.stub.ServiceUploaderStub;
import org.wso2.carbon.aarservices.stub.types.carbon.AARServiceData;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class AARServiceUploaderClient {
    private static final Log log = LogFactory.getLog(AARServiceUploaderClient.class);
    private final String serviceName = "ServiceUploader";
    private ServiceUploaderStub serviceUploaderStub;

    public AARServiceUploaderClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "ServiceUploader";
        try {
            this.serviceUploaderStub = new ServiceUploaderStub(endPoint);
            AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.serviceUploaderStub);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("ServiceUploaderStub Initialization fail " + axisFault.getMessage()));
            throw new AxisFault("ServiceUploaderStub Initialization fail " + axisFault.getMessage());
        }
    }

    public AARServiceUploaderClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "ServiceUploader";
        try {
            this.serviceUploaderStub = new ServiceUploaderStub(endPoint);
            AuthenticateStub.authenticateStub(userName, password, (Stub)this.serviceUploaderStub);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("ServiceUploaderStub Initialization fail " + axisFault.getMessage()));
            throw new AxisFault("ServiceUploaderStub Initialization fail " + axisFault.getMessage());
        }
    }

    public void uploadAARFile(String fileName, String filePath, String serviceHierarchy) throws ExceptionException, RemoteException, MalformedURLException {
        AARServiceData aarServiceData = new AARServiceData();
        aarServiceData.setFileName(fileName);
        aarServiceData.setDataHandler(this.createDataHandler(filePath));
        aarServiceData.setServiceHierarchy(serviceHierarchy);
        this.serviceUploaderStub.uploadService(new AARServiceData[]{aarServiceData});
    }

    private DataHandler createDataHandler(String filePath) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL("file://" + filePath);
        }
        catch (MalformedURLException e) {
            log.error((Object)("File path URL is invalid" + String.valueOf(e)));
            throw new MalformedURLException("File path URL is invalid" + String.valueOf(e));
        }
        DataHandler dh = new DataHandler(url);
        return dh;
    }
}

