/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.database.utils.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.wso2.carbon.database.utils.jdbc.JdbcConstants;
import org.wso2.carbon.database.utils.jdbc.JdbcUtils;
import org.wso2.carbon.database.utils.jdbc.QueryFilter;
import org.wso2.carbon.database.utils.jdbc.RowMapper;
import org.wso2.carbon.database.utils.jdbc.TransactionManager;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;

public class Template<T> {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private static final String ID = "ID";

    public <T> int executeInsert(String query, QueryFilter queryFilter, T bean, boolean fetchInsertedId) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try {
            if (fetchInsertedId) {
                int resultId;
                block40: {
                    String dbProductName = connection.getMetaData().getDatabaseProductName();
                    try (PreparedStatement preparedStatement = connection.prepareStatement(query, new String[]{JdbcUtils.getConvertedAutoGeneratedColumnName(dbProductName, ID)});){
                        this.doInternalUpdate(queryFilter, preparedStatement);
                        this.logDebug("Mapping generated key (Auto Increment ID) to the object", new Object[0]);
                        try (ResultSet generatedKeys = preparedStatement.getGeneratedKeys();){
                            if (generatedKeys.next()) {
                                resultId = generatedKeys.getInt(1);
                                this.logDebug("Newly inserted ID (Auto Increment ID) is {} for the bean {} ", resultId, bean);
                                break block40;
                            }
                            throw new SQLException(JdbcConstants.ErrorCodes.ERROR_CODE_AUTO_GENERATED_ID_FAILURE.getErrorMessage());
                        }
                    }
                }
                return resultId;
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                this.doInternalUpdate(queryFilter, preparedStatement);
            }
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database insert: {} with parameters {}", query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING.getErrorMessage() + query, JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING.getErrorCode(), e);
        }
        return 0;
    }

    public <T> int executeBatchInsert(String query, QueryFilter queryFilter, T bean) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            this.doInternalBatchUpdate(queryFilter, preparedStatement);
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database insert: {} with parameters {}", query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
        return 0;
    }

    public <T> List<T> executeQuery(String query, RowMapper<T> rowMapper) throws DataAccessException {
        return this.executeQuery(query, rowMapper, null);
    }

    public <T> List<T> executeQuery(String query, RowMapper<T> rowMapper, QueryFilter queryFilter) throws DataAccessException {
        ArrayList<T> result = new ArrayList<T>();
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            if (queryFilter != null) {
                queryFilter.filter(preparedStatement);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                int i = 0;
                while (resultSet.next()) {
                    T row = rowMapper.mapRow(resultSet, i);
                    result.add(row);
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            this.logDebug("There has been an error performing the database query. The query is {}, and the Parameters are {}", e, query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
        return result;
    }

    public <T> T fetchSingleRecord(String query, RowMapper<T> rowMapper, QueryFilter queryFilter) throws DataAccessException {
        T result = null;
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            if (queryFilter != null) {
                queryFilter.filter(preparedStatement);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    result = rowMapper.mapRow(resultSet, 0);
                }
                if (!resultSet.isClosed() && resultSet.next()) {
                    this.logDebug("There are more records than one found for query: {} for the parameters {}", query, queryFilter);
                    throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_MORE_RECORDS_IN_SINGLE_FETCH.getErrorMessage() + query);
                }
            }
        }
        catch (SQLException e) {
            this.logDebug("There has been an error performing the database query. The query is {}, and the parameters are {}", e, query, rowMapper, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
        return result;
    }

    public void executeUpdate(String query, QueryFilter queryFilter) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            if (queryFilter != null) {
                queryFilter.filter(preparedStatement);
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database update: {} with parameters {}", query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String query) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int n = this.doInternalUpdate(null, preparedStatement);
            return n;
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database update: {}", query);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
    }

    private int doInternalUpdate(QueryFilter queryFilter, PreparedStatement preparedStatement) throws SQLException, DataAccessException {
        if (queryFilter != null) {
            queryFilter.filter(preparedStatement);
        }
        return preparedStatement.executeUpdate();
    }

    private <T> void doInternalBatchUpdate(QueryFilter queryFilter, PreparedStatement preparedStatement) throws SQLException, DataAccessException {
        if (queryFilter != null) {
            queryFilter.filter(preparedStatement);
        }
        preparedStatement.executeBatch();
    }

    private void logDebug(String s, Object ... params) {
        this.logDebug(s, null, params);
    }

    private void logDebug(String s, Exception e, Object ... params) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormatter.arrayFormat((String)s, (Object[])params).getMessage(), (Throwable)e);
        }
    }
}

