/*
 * Copyright (c) 2018, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.wso2.carbon.database.utils.jdbc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Provide support for the Jdbc template executions.
 */
public final class JdbcUtils {

    private static Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {

    }

    public static String getConvertedAutoGeneratedColumnName(String dbProductName, String columnName) {

        String autoGeneratedColumnName = columnName;
        if (JdbcConstants.PRODUCT_NAME_POSTGRESQL.equals(dbProductName)) {
            autoGeneratedColumnName = columnName.toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug("Database product name is PostgreSQL. Converting column name " + columnName + " " +
                        "to lowercase (" + autoGeneratedColumnName + ").");
            }
        }

        return autoGeneratedColumnName;
    }
}
