/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.launcher.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final String VAR_REGEXP = "\\$\\{[^}]*}";
    private static final Pattern varPattern = Pattern.compile("\\$\\{[^}]*}");

    private Utils() {
    }

    public static String initializeSystemProperties(String value) {
        String newValue = value;
        Matcher matcher = varPattern.matcher(value);
        while (matcher.find()) {
            String sysPropKey = value.substring(matcher.start() + 2, matcher.end() - 1);
            String sysPropValue = Utils.getSystemVariableValue(sysPropKey, null);
            if (Utils.isNullOrEmpty(sysPropValue)) {
                throw new RuntimeException("System property " + sysPropKey + " cannot be null");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            newValue = newValue.replaceFirst(VAR_REGEXP, sysPropValue);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Substitute Variables before: " + value + ", after: " + newValue);
        }
        return newValue;
    }

    public static String getSystemVariableValue(String variableName, String defaultValue) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : defaultValue);
        return value;
    }

    public static Path getCarbonHomeDirectory() {
        return Paths.get(System.getProperty("carbon.home"), new String[0]);
    }

    public static Path getLaunchConfigDirectory() {
        return Paths.get(System.getProperty("carbon.home"), "conf", System.getProperty("wso2.runtime"), "osgi");
    }

    public static boolean isNullOrEmpty(String arg) {
        return arg == null || arg.length() == 0;
    }

    public static String[] tokenize(String list, String delimiter) {
        if (Utils.isNullOrEmpty(list)) {
            return new String[0];
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(list, delimiter);
        while (stringTokenizer.hasMoreElements()) {
            String token = stringTokenizer.nextToken().trim();
            if (Utils.isNullOrEmpty(token)) continue;
            tokenList.add(token);
        }
        return tokenList.toArray(new String[tokenList.size()]);
    }
}

