/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.launcher.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public class FileResolver {
    private FileResolver() {
    }

    public static URL resolve(String path, String parentPath) {
        Path filePath;
        if (path.contains(":") && !path.startsWith("file:")) {
            throw new RuntimeException("URLs other than file URLs are not supported.");
        }
        String relativeFilePath = path;
        if (path.startsWith("file:")) {
            relativeFilePath = path.substring(5);
        }
        if ((filePath = Paths.get(relativeFilePath, new String[0])).isAbsolute()) {
            return FileResolver.pathByOS(filePath.toString());
        }
        filePath = Paths.get(parentPath, relativeFilePath);
        if (filePath.isAbsolute()) {
            return FileResolver.pathByOS(filePath.toString());
        }
        return null;
    }

    private static URL pathByOS(String path) {
        URL filePathURL;
        try {
            filePathURL = System.getProperty("os.name").toLowerCase(Locale.getDefault()).contains("windows") ? new URL("file:" + path) : new URL("file://" + path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return filePathURL;
    }
}

