/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.launcher.extensions;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.launcher.CarbonServerEvent;
import org.wso2.carbon.launcher.CarbonServerListener;
import org.wso2.carbon.launcher.extensions.OSGiLibBundleDeployerUtils;
import org.wso2.carbon.launcher.extensions.model.BundleInfo;
import org.wso2.carbon.launcher.utils.Utils;

public class OSGiLibBundleDeployer
implements CarbonServerListener {
    private static final Logger logger = Logger.getLogger(OSGiLibBundleDeployer.class.getName());

    @Override
    public void notify(CarbonServerEvent event) {
        if (event.getType() == 1) {
            Path carbonHome = Utils.getCarbonHomeDirectory();
            Path libDirectoryPath = Paths.get(carbonHome.toString(), "lib");
            String profile = Optional.ofNullable(System.getProperty("wso2.runtime")).orElse("default");
            try {
                logger.log(Level.FINE, "Loading the new OSGi bundle information from lib folder...");
                List<BundleInfo> newBundlesInfo = OSGiLibBundleDeployerUtils.getBundlesInfo(libDirectoryPath);
                logger.log(Level.FINE, "Successfully loaded the new OSGi bundle information from lib folder");
                OSGiLibBundleDeployerUtils.updateOSGiLib(carbonHome.toString(), profile, newBundlesInfo);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to update the OSGi bundle information of Carbon Runtime: " + profile, e);
            }
        }
    }
}

