/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.launcher;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.wso2.carbon.launcher.CarbonServerEvent;
import org.wso2.carbon.launcher.ServerStatus;
import org.wso2.carbon.launcher.config.CarbonInitialBundle;
import org.wso2.carbon.launcher.config.CarbonLaunchConfig;

public class CarbonServer {
    private static final Logger logger = Logger.getLogger(CarbonServer.class.getName());
    private CarbonLaunchConfig config;
    private Framework framework;
    private ServerStatus serverStatus;

    public CarbonServer(CarbonLaunchConfig config) {
        this.config = config;
    }

    public void start() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting Carbon server instance.");
        }
        System.setProperty("carbon.start.time", Long.toString(System.currentTimeMillis()));
        try {
            ClassLoader fwkClassLoader = this.createOSGiFwkClassLoader();
            FrameworkFactory fwkFactory = this.loadOSGiFwkFactory(fwkClassLoader);
            this.framework = fwkFactory.newFramework(this.config.getProperties());
            this.setServerCurrentStatus(ServerStatus.STARTING);
            this.dispatchEvent(1);
            this.initAndStartOSGiFramework(this.framework);
            this.loadInitialBundles(this.framework.getBundleContext());
            this.setServerCurrentStatus(ServerStatus.STARTED);
            this.waitForServerStop(this.framework);
            this.setServerCurrentStatus(ServerStatus.STOPPING);
            this.dispatchEvent(2);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void stop() {
        if (!this.isFrameworkActive()) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Stopping the OSGi framework.");
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    CarbonServer.this.framework.stop();
                }
                catch (BundleException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    throw new RuntimeException(e);
                }
            }
        }.start();
        try {
            FrameworkEvent event = this.framework.waitForStop(180000L);
            if (event.getType() == 512 && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "OSGi framework did not stop during the given time.");
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void initAndStartOSGiFramework(Framework framework) throws BundleException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Initializing the OSGi framework.");
        }
        framework.init();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting the OSGi framework.");
        }
        framework.start();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Started the OSGi framework.");
        }
    }

    private void waitForServerStop(Framework framework) throws Exception {
        block2: {
            FrameworkEvent event;
            if (!this.isFrameworkActive()) {
                return;
            }
            while ((event = framework.waitForStop(0L)).getType() == 128) {
            }
            if (!logger.isLoggable(Level.FINE)) break block2;
            logger.log(Level.FINE, "OSGi framework is stopped for update.");
        }
    }

    private ClassLoader createOSGiFwkClassLoader() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating OSGi framework class loader.");
        }
        URL fwkBundleURL = this.config.getCarbonOSGiFramework();
        return new URLClassLoader(new URL[]{fwkBundleURL});
    }

    private FrameworkFactory loadOSGiFwkFactory(ClassLoader classLoader) {
        ServiceLoader<FrameworkFactory> loader;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Loading OSGi FrameworkFactory implementation class from the classpath.");
        }
        if (!(loader = ServiceLoader.load(FrameworkFactory.class, classLoader)).iterator().hasNext()) {
            throw new RuntimeException("An implementation of the " + FrameworkFactory.class.getName() + " must be available in the classpath");
        }
        return loader.iterator().next();
    }

    private void loadInitialBundles(BundleContext bundleContext) throws BundleException {
        System.setProperty("org.eclipse.equinox.simpleconfigurator.exclusiveInstallation", "false");
        for (CarbonInitialBundle initialBundleInfo : this.config.getInitialBundles()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Loading initial bundle: " + initialBundleInfo.getLocation().toExternalForm() + " with startlevel " + initialBundleInfo.getLevel());
            }
            Bundle bundle = bundleContext.installBundle(initialBundleInfo.getLocation().toString());
            if (!initialBundleInfo.shouldStart()) continue;
            bundle.start();
        }
    }

    private boolean isFrameworkActive() {
        return this.framework != null && (this.framework.getState() == 32 || this.framework.getState() == 8);
    }

    private void setServerCurrentStatus(ServerStatus status) {
        this.serverStatus = status;
    }

    public ServerStatus getServerCurrentStatus() {
        return this.serverStatus;
    }

    private void dispatchEvent(int event) {
        CarbonServerEvent carbonServerEvent = new CarbonServerEvent(event, this.config);
        this.config.getCarbonServerListeners().forEach(listener -> {
            if (logger.isLoggable(Level.FINE)) {
                String eventName = event == 1 ? "STARTING" : "STOPPING";
                logger.log(Level.FINE, "Dispatching " + eventName + " event to " + listener.getClass().getName());
            }
            listener.notify(carbonServerEvent);
        });
    }
}

