/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tools.spi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.spi.InitialContextFactory;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.wso2.carbon.tools.CarbonTool;
import org.wso2.carbon.tools.converter.utils.BundleGeneratorUtils;
import org.wso2.carbon.tools.exception.CarbonToolException;

public class ICFProviderTool
implements CarbonTool {
    private static final Logger logger = Logger.getLogger(ICFProviderTool.class.getName());
    private static final String ACTIVATOR_CLASS_FILE = "CustomBundleActivator.class";
    private static final String ACTIVATOR_JAVA_FILE = "CustomBundleActivator.java";
    private static final String INTERNAL_PKG_NAME = "internal";
    private static final String ACTIVATOR_FULL_QUALIFIED_NAME = "internal.CustomBundleActivator";
    private static final String CLASS_TEMPLATE = "package internal;\nimport org.osgi.framework.BundleActivator;\nimport org.osgi.framework.BundleContext;\nimport %s;\n\nimport javax.naming.spi.InitialContextFactory;\n\npublic class CustomBundleActivator implements BundleActivator {\n\n    @Override\n    public void start(BundleContext bundleContext) throws Exception {\n        bundleContext.registerService(new String[] { \"" + InitialContextFactory.class.getName() + "\", \"%s\" }, new %s(), null);\n    }\n\n    @Override\n    public void stop(BundleContext bundleContext) throws Exception {\n\n    }\n}\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... toolArgs) {
        if (toolArgs.length < 3 || toolArgs.length > 4) {
            String message = "Improper usage detected. Usage: icf-provider.sh|bat [ICF Impl class] [jar file] [destination] [OSGi jar path]First 3 arguments are compulsory.";
            logger.log(Level.INFO, message);
            return;
        }
        String spiImpl = toolArgs[0];
        Path jarFile = Paths.get(toolArgs[1], new String[0]);
        Path destination = Paths.get(toolArgs[2], new String[0]);
        String osgiJar = toolArgs.length == 4 && !toolArgs[3].isEmpty() ? toolArgs[3] : Paths.get(System.getProperty("carbon.home"), "wso2", "lib", "plugins", "org.eclipse.osgi_3.14.0").toString();
        Path fileName = jarFile.getFileName();
        if (fileName == null) {
            return;
        }
        String jarFileName = fileName.toString();
        Path tmpDir = destination.resolve(jarFileName.substring(0, jarFileName.lastIndexOf(".")));
        Process process = null;
        if (Files.exists(jarFile, new LinkOption[0]) && Files.exists(destination, new LinkOption[0]) && Files.isWritable(destination) && !Files.exists(tmpDir, new LinkOption[0])) {
            FileOutputStream fileOutputStream = null;
            try {
                Files.createDirectory(tmpDir, new FileAttribute[0]);
                String source = String.format(CLASS_TEMPLATE, spiImpl, spiImpl, spiImpl);
                Path internal = Files.createDirectory(tmpDir.resolve(INTERNAL_PKG_NAME), new FileAttribute[0]);
                File sourceFile = new File(internal.toFile(), ACTIVATOR_JAVA_FILE);
                Files.write(internal.resolve(ACTIVATOR_JAVA_FILE), source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
                    System.setProperty("java.home", System.getenv("JAVA_HOME"));
                }
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                ArrayList<String> compilerArgs = new ArrayList<String>();
                compilerArgs.add("-cp");
                String separator = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows") ? ";" : ":";
                compilerArgs.add(jarFile.toString() + separator + osgiJar);
                compilerArgs.add(sourceFile.getPath());
                fileOutputStream = new FileOutputStream(internal.resolve(ACTIVATOR_CLASS_FILE).toFile());
                compiler.run(null, fileOutputStream, null, compilerArgs.toArray(new String[0]));
                Path finalJarPath = tmpDir.resolve(jarFileName);
                Files.copy(jarFile, finalJarPath, new CopyOption[0]);
                StringBuilder command = new StringBuilder();
                command.append("jar uf ").append(finalJarPath.toString()).append(" -C ").append(tmpDir.toString()).append(" ").append(internal.resolve(ACTIVATOR_CLASS_FILE).toString().replace(tmpDir.toString(), ""));
                logger.log(Level.INFO, "Executing '" + command.toString() + "'");
                process = Runtime.getRuntime().exec(command.toString());
                process.waitFor(5L, TimeUnit.SECONDS);
                this.addBundleActivatorHeader(finalJarPath, tmpDir);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while running SPI Creator", e);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Error while adding SPI", e);
            }
            catch (CarbonToolException e) {
                logger.log(Level.SEVERE, "Error while converting to bundle", e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Error while closing OutputStream", e);
                    }
                }
            }
        } else {
            String message = "The destination location '" + tmpDir.toString() + "' already exist/does not have write permissions or jar file doesn't exist";
            logger.log(Level.WARNING, message);
        }
    }

    private void addBundleActivatorHeader(Path finalJarPath, Path destination) throws IOException, CarbonToolException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Bundle-Activator", ACTIVATOR_FULL_QUALIFIED_NAME);
        if (BundleGeneratorUtils.isOSGiBundle(finalJarPath)) {
            Throwable throwable;
            logger.log(Level.INFO, "Adding 'Bundle-Activator: CustomBundleActivator' to MANIFEST.MF");
            Path manifestmfFile = destination.resolve("MANIFEST.MF");
            try (JarFile jar = new JarFile(finalJarPath.toString());){
                throwable = null;
                try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(manifestmfFile.toFile()), "UTF-8"));
                     InputStream inputStream2 = jar.getInputStream(jar.getEntry("META-INF/MANIFEST.MF"));){
                    Files.copy(inputStream2, destination.resolve("MANIFEST.MF.tmp"), new CopyOption[0]);
                    List<String> existingManifest = Files.readAllLines(destination.resolve("MANIFEST.MF.tmp"));
                    existingManifest.add("Bundle-Activator: internal.CustomBundleActivator");
                    existingManifest.forEach(printWriter::println);
                    printWriter.flush();
                }
                catch (Throwable inputStream2) {
                    throwable = inputStream2;
                    throw inputStream2;
                }
            }
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            URI uri = URI.create("jar:file:" + finalJarPath.toString());
            throwable = null;
            try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
                Path pathInZipfile = zipfs.getPath("META-INF", "MANIFEST.MF");
                Files.copy(manifestmfFile, pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            logger.log(Level.INFO, "Created bundle file: '" + finalJarPath.toString());
        } else {
            logger.log(Level.INFO, "Running jar to bundle conversion");
            BundleGeneratorUtils.convertFromJarToBundle(finalJarPath, destination, manifest, "");
        }
    }
}

