/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tools.converter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.tools.CarbonTool;
import org.wso2.carbon.tools.converter.utils.BundleGeneratorUtils;
import org.wso2.carbon.tools.exception.CarbonToolException;

public class BundleGeneratorTool
implements CarbonTool {
    private static final Logger logger = Logger.getLogger(BundleGeneratorTool.class.getName());

    @Override
    public void execute(String[] toolArgs) {
        int sourceIndex = 0;
        int destinationIndex = 1;
        int executingDirectoryIndex = 2;
        if (!(toolArgs.length != 3 || toolArgs[sourceIndex].isEmpty() || toolArgs[destinationIndex].isEmpty() || toolArgs[executingDirectoryIndex].isEmpty())) {
            Optional<Path> source = BundleGeneratorTool.getPath(toolArgs[sourceIndex], toolArgs[executingDirectoryIndex]);
            Optional<Path> destination = BundleGeneratorTool.getPath(toolArgs[destinationIndex], toolArgs[executingDirectoryIndex]);
            if (source.isPresent() && destination.isPresent()) {
                if (Files.isReadable(source.get()) && Files.isWritable(destination.get())) {
                    try {
                        if (!Files.isDirectory(source.get(), new LinkOption[0])) {
                            BundleGeneratorUtils.convertFromJarToBundle(source.get(), destination.get(), new Manifest(), "");
                        }
                        List<Path> directoryContent = BundleGeneratorUtils.listFiles(source.get());
                        for (Path aDirectoryItem : directoryContent) {
                            if (!aDirectoryItem.toString().endsWith(".jar")) continue;
                            BundleGeneratorUtils.convertFromJarToBundle(aDirectoryItem, destination.get(), new Manifest(), "");
                        }
                    }
                    catch (IOException | CarbonToolException e) {
                        logger.log(Level.SEVERE, "An error occurred when making the JAR (Java Archive) to OSGi bundle conversion", e);
                    }
                } else {
                    String message = "The source location and/or bundle destination does not have appropriate read/write permissions.";
                    logger.log(Level.WARNING, message);
                }
            } else {
                logger.log(Level.WARNING, "Invalid file path(s)");
            }
        } else {
            String message = "Improper usage detected. Usage: jartobundle.sh/.bat [source file/directory] [destination folder], both arguments source and destination are compulsory";
            logger.log(Level.INFO, message);
        }
    }

    private static Optional<Path> getPath(String userPathInput, String executingDirectory) {
        if (userPathInput != null) {
            Path path = Paths.get(userPathInput, new String[0]);
            if (!path.isAbsolute()) {
                path = Paths.get(executingDirectory, userPathInput);
            }
            if (Files.exists(path, new LinkOption[0])) {
                return Optional.of(path);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

