/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.tools.CarbonTool;
import org.wso2.carbon.tools.converter.utils.BundleGeneratorUtils;
import org.wso2.carbon.tools.exception.CarbonToolException;
import org.wso2.carbon.utils.FileUtils;

public class InstallJarsTool
implements CarbonTool {
    private static final Logger logger = Logger.getLogger(InstallJarsTool.class.getName());
    private static final String BUNDLE_BACKUP_DIR_NAME = "_lib";
    private static final String META_DATA_DIR_NAME = ".meta";
    private static final String LIB_DIR_NAME = "lib";
    private static final String JARS_DIR_NAME = ".jars";
    private static final String BUNDLE_DIR_NAME = ".bundles";
    private static final String JARS_META_FILE = "jarsMeta";
    private static final String BUNDLE_META_FILE = "bundleMeta";
    private static final Pattern EXTRACT_JAR_NAME_PATTERN = Pattern.compile("(.*)-\\d+\\.\\d+\\.\\d+(\\.jar)$");
    private String carbonHome;

    @Override
    public void execute(String ... toolArgs) {
        this.carbonHome = toolArgs[0];
        Path jarSourcePath = Paths.get(this.carbonHome, JARS_DIR_NAME);
        Path bundleSourcePath = Paths.get(this.carbonHome, BUNDLE_DIR_NAME);
        Path outputPath = Paths.get(this.carbonHome, LIB_DIR_NAME);
        File jarsDir = jarSourcePath.toFile();
        File bundlesDir = bundleSourcePath.toFile();
        File outputDir = outputPath.toFile();
        if (Files.isReadable(jarSourcePath) && Files.isReadable(bundleSourcePath) && Files.isWritable(outputPath)) {
            try {
                File metaDir = new File(this.carbonHome, META_DATA_DIR_NAME);
                File[] jars = this.listJarsInDirectory(jarsDir);
                File[] bundles = this.listJarsInDirectory(bundlesDir);
                File jarMetaFile = new File(metaDir, JARS_META_FILE);
                File bundleMetaFile = new File(metaDir, BUNDLE_META_FILE);
                boolean isJarDirectoryUpdated = this.isDirectoryUpdated(jarMetaFile, jarsDir);
                boolean isBundleDirectoryUpdated = this.isDirectoryUpdated(bundleMetaFile, bundlesDir);
                boolean isReverted = false;
                if (isBundleDirectoryUpdated || isJarDirectoryUpdated) {
                    this.revertLibDirToDefault();
                    isReverted = true;
                }
                if (jars != null && (isJarDirectoryUpdated || !jarMetaFile.exists() && jars.length > 0 || isReverted)) {
                    this.backupLibDirectory(outputDir);
                    for (File jar : jars) {
                        BundleGeneratorUtils.convertFromJarToBundle(jar.toPath(), outputPath, new Manifest(), "");
                    }
                    this.updateMetaFile(jarsDir, jarMetaFile);
                }
                if (bundles != null && (isJarDirectoryUpdated || !bundleMetaFile.exists() && bundles.length > 0 || isReverted)) {
                    this.backupLibDirectory(outputDir);
                    for (File bundle : bundles) {
                        String bundleArtifactName;
                        String bundleName = bundle.getName();
                        Matcher matcher = EXTRACT_JAR_NAME_PATTERN.matcher(bundleName);
                        if (matcher.matches() && (bundleArtifactName = matcher.group(1)) != null) {
                            this.cleanExistingBundle(outputDir, bundleArtifactName);
                        }
                        FileUtils.copyFileToDir((File)bundle, (File)outputDir);
                    }
                    this.updateMetaFile(bundlesDir, bundleMetaFile);
                }
            }
            catch (IOException | CarbonToolException e) {
                logger.log(Level.SEVERE, "An error occurred while installing Jars and Bundles to the distribution.", e);
            }
        } else {
            String message = "The jars location:" + jarSourcePath + " and/or bundle location:" + bundleSourcePath + " and/or lib location:" + outputPath + "  does not have appropriate read/write permissions.";
            logger.log(Level.WARNING, message);
        }
    }

    private boolean isDirectoryUpdated(File metaDataFile, File directory) throws IOException {
        if (metaDataFile.exists()) {
            try (BufferedReader bufReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(metaDataFile), Charset.defaultCharset()));){
                String metaReadInfo = bufReader.readLine();
                if (metaReadInfo != null) {
                    boolean bl = !metaReadInfo.equalsIgnoreCase(Long.toString(directory.lastModified()));
                    return bl;
                }
            }
        }
        return false;
    }

    private void revertLibDirToDefault() throws IOException {
        File libDir = new File(this.carbonHome, LIB_DIR_NAME);
        File backupLibDir = new File(this.carbonHome, BUNDLE_BACKUP_DIR_NAME);
        if (libDir.exists() && backupLibDir.exists()) {
            File[] bundles;
            logger.info("Reverting " + libDir.toPath() + " to default version.");
            FileUtils.deleteDir((File)libDir);
            for (File bundle : bundles = this.listJarsInDirectory(backupLibDir)) {
                FileUtils.copyFileToDir((File)bundle, (File)libDir);
            }
        }
    }

    private void backupLibDirectory(File bundleDir) throws IOException {
        File bundleBackupDir = new File(this.carbonHome, BUNDLE_BACKUP_DIR_NAME);
        boolean alreadyBackedUp = bundleBackupDir.exists();
        if (!alreadyBackedUp) {
            File[] jarsInDir;
            for (File jar : jarsInDir = this.listJarsInDirectory(bundleDir)) {
                FileUtils.copyFileToDir((File)jar, (File)bundleBackupDir);
            }
            logger.info("Backed up lib to " + bundleBackupDir.toPath());
        }
    }

    private void updateMetaFile(File directory, File metaFile) {
        File metaDir = new File(this.carbonHome, META_DATA_DIR_NAME);
        if (!metaDir.exists() && metaDir.mkdir()) {
            logger.info(".meta successfully created on " + metaDir.toPath());
        }
        this.writeToFile(metaFile, Long.toString(directory.lastModified()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File file, String content) {
        BufferedWriter bufWriter = null;
        try {
            bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.defaultCharset()));
            bufWriter.write(content);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An error occurred while writing to file " + file.toPath(), e);
        }
        finally {
            if (bufWriter != null) {
                try {
                    bufWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void cleanExistingBundle(File bundleDir, String bundleName) {
        File[] files = bundleDir.listFiles((dir, name) -> name.matches(bundleName + ".*\\.jar"));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) continue;
                logger.log(Level.SEVERE, "Failed to clean existing bundle, " + file.getAbsolutePath());
            }
        }
    }

    private File[] listJarsInDirectory(File jarsDir) {
        File[] files = new File[]{};
        if (jarsDir.exists()) {
            files = jarsDir.listFiles((dir, name) -> name.endsWith(".jar"));
            return files;
        }
        logger.warning("Directory " + jarsDir.getPath() + " does not exist.");
        return files;
    }
}

