/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundResponseSender;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketChannelContext;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketSourceHandler;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.WebsocketLogUtil;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketEndpointManager;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketSubscriberPathManager;

public class InboundWebsocketResponseSender
implements InboundResponseSender {
    private Log log = LogFactory.getLog(InboundWebsocketResponseSender.class);
    private InboundWebsocketSourceHandler sourceHandler;

    public InboundWebsocketResponseSender(InboundWebsocketSourceHandler sourceHandler) {
        this.sourceHandler = sourceHandler;
    }

    public InboundWebsocketSourceHandler getSourceHandler() {
        return this.sourceHandler;
    }

    public void sendBack(org.apache.synapse.MessageContext msgContext) {
        String defaultContentType = this.sourceHandler.getDefaultContentType();
        if (msgContext != null) {
            BinaryWebSocketFrame frame;
            Integer errorCode = null;
            String errorMessage = null;
            if (msgContext.getProperty("errorCode") != null) {
                errorCode = Integer.parseInt(msgContext.getProperty("errorCode").toString());
            }
            if (msgContext.getProperty("ERROR_MESSAGE") != null) {
                errorMessage = msgContext.getProperty("ERROR_MESSAGE").toString();
            }
            try {
                if (errorCode != null && errorMessage != null) {
                    CloseWebSocketFrame closeWebSocketFrame = new CloseWebSocketFrame(errorCode.intValue(), errorMessage);
                    if (this.log.isDebugEnabled()) {
                        String customErrorMessage = "errorCode:" + errorCode + " error message: " + errorMessage;
                        WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)closeWebSocketFrame, this.sourceHandler.getChannelHandlerContext().getChannelHandlerContext(), customErrorMessage, false);
                    }
                    this.sourceHandler.handleClientWebsocketChannelTermination((WebSocketFrame)closeWebSocketFrame);
                }
            }
            catch (AxisFault fault) {
                this.log.error((Object)"Error occurred while sending close frames", (Throwable)fault);
            }
            Object isTCPTransport = ((Axis2MessageContext)msgContext).getAxis2MessageContext().getProperty("isTCPTransport");
            if (msgContext.getProperty("source.handshake.present") != null && msgContext.getProperty("source.handshake.present").equals(true)) {
                return;
            }
            if (msgContext.getProperty("websocket.target.handshake.present") != null && msgContext.getProperty("websocket.target.handshake.present").equals(true)) {
                if (msgContext.getProperty("websocket.target.handler.context") != null) {
                    ChannelHandlerContext targetCtx = (ChannelHandlerContext)msgContext.getProperty("websocket.target.handler.context");
                    if (this.log.isDebugEnabled()) {
                        WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)new CloseWebSocketFrame(), targetCtx, false);
                    }
                    this.sourceHandler.getChannelHandlerContext().addCloseListener(targetCtx);
                }
                return;
            }
            if (msgContext.getProperty("websocket.binary.frame.present") != null && msgContext.getProperty("websocket.binary.frame.present").equals(true)) {
                frame = (BinaryWebSocketFrame)msgContext.getProperty("websocket.binary.frame");
                if (isTCPTransport != null && ((Boolean)isTCPTransport).booleanValue()) {
                    try {
                        RelayUtils.buildMessage((MessageContext)((Axis2MessageContext)msgContext).getAxis2MessageContext(), (boolean)false);
                        if (defaultContentType != null && defaultContentType.startsWith("binary")) {
                            MessageContext msgCtx = ((Axis2MessageContext)msgContext).getAxis2MessageContext();
                            MessageFormatter messageFormatter = BaseUtils.getMessageFormatter((MessageContext)msgCtx);
                            OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgCtx);
                            byte[] message = messageFormatter.getBytes(msgCtx, format);
                            frame = new BinaryWebSocketFrame(Unpooled.copiedBuffer((byte[])message));
                            InboundWebsocketChannelContext ctx = this.sourceHandler.getChannelHandlerContext();
                            int clientBroadcastLevel = this.sourceHandler.getClientBroadcastLevel();
                            String subscriberPath = this.sourceHandler.getSubscriberPath();
                            WebsocketSubscriberPathManager pathManager = WebsocketSubscriberPathManager.getInstance();
                            if (this.log.isDebugEnabled()) {
                                WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)frame, ctx.getChannelHandlerContext(), false);
                            }
                            this.handleSendBack((WebSocketFrame)frame, ctx, clientBroadcastLevel, subscriberPath, pathManager);
                            return;
                        }
                    }
                    catch (XMLStreamException ex) {
                        this.log.error((Object)"Error while building message", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        this.log.error((Object)"Failed for format message to specified output format", (Throwable)ex);
                    }
                }
                InboundWebsocketChannelContext ctx = this.sourceHandler.getChannelHandlerContext();
                int clientBroadcastLevel = this.sourceHandler.getClientBroadcastLevel();
                String subscriberPath = this.sourceHandler.getSubscriberPath();
                WebsocketSubscriberPathManager pathManager = WebsocketSubscriberPathManager.getInstance();
                if (this.log.isDebugEnabled()) {
                    WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)frame, ctx.getChannelHandlerContext(), false);
                }
                this.handleSendBack((WebSocketFrame)frame, ctx, clientBroadcastLevel, subscriberPath, pathManager);
            } else if (msgContext.getProperty("websocket.text.frame.present") != null && msgContext.getProperty("websocket.text.frame.present").equals(true)) {
                frame = (TextWebSocketFrame)msgContext.getProperty("websocket.text.frame");
                if (isTCPTransport != null && ((Boolean)isTCPTransport).booleanValue()) {
                    try {
                        RelayUtils.buildMessage((MessageContext)((Axis2MessageContext)msgContext).getAxis2MessageContext(), (boolean)false);
                        if (defaultContentType != null && defaultContentType.startsWith("text")) {
                            String backendMessageType = (String)((Axis2MessageContext)msgContext).getAxis2MessageContext().getProperty("backendMessageType");
                            ((Axis2MessageContext)msgContext).getAxis2MessageContext().setProperty("messageType", (Object)backendMessageType);
                            frame = new TextWebSocketFrame(this.messageContextToText(((Axis2MessageContext)msgContext).getAxis2MessageContext()));
                            InboundWebsocketChannelContext ctx = this.sourceHandler.getChannelHandlerContext();
                            int clientBroadcastLevel = this.sourceHandler.getClientBroadcastLevel();
                            String subscriberPath = this.sourceHandler.getSubscriberPath();
                            WebsocketSubscriberPathManager pathManager = WebsocketSubscriberPathManager.getInstance();
                            if (this.log.isDebugEnabled()) {
                                WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)frame, ctx.getChannelHandlerContext(), false);
                            }
                            this.handleSendBack((WebSocketFrame)frame, ctx, clientBroadcastLevel, subscriberPath, pathManager);
                            return;
                        }
                    }
                    catch (XMLStreamException ex) {
                        this.log.error((Object)"Error while building message", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        this.log.error((Object)"Failed for format message to specified output format", (Throwable)ex);
                    }
                }
                InboundWebsocketChannelContext ctx = this.sourceHandler.getChannelHandlerContext();
                int clientBroadcastLevel = this.sourceHandler.getClientBroadcastLevel();
                String subscriberPath = this.sourceHandler.getSubscriberPath();
                WebsocketSubscriberPathManager pathManager = WebsocketSubscriberPathManager.getInstance();
                if (this.log.isDebugEnabled()) {
                    WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)frame, ctx.getChannelHandlerContext(), false);
                }
                this.handleSendBack((WebSocketFrame)frame, ctx, clientBroadcastLevel, subscriberPath, pathManager);
            } else {
                try {
                    Object wsCloseFrameStatusCode = msgContext.getProperty("websocket.close.frame.status.code");
                    String wsCloseFrameReasonText = (String)msgContext.getProperty("websocket.close.frame.reason.text");
                    int statusCode = 1001;
                    if (wsCloseFrameStatusCode != null) {
                        statusCode = (Integer)wsCloseFrameStatusCode;
                    }
                    if (wsCloseFrameStatusCode == null) {
                        wsCloseFrameReasonText = "Unexpected frame type";
                    }
                    if (wsCloseFrameStatusCode != null && wsCloseFrameReasonText != null) {
                        CloseWebSocketFrame closeWebSocketFrame = new CloseWebSocketFrame(statusCode, wsCloseFrameReasonText);
                        if (this.log.isDebugEnabled()) {
                            WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)closeWebSocketFrame, this.sourceHandler.getChannelHandlerContext().getChannelHandlerContext(), false);
                        }
                        this.sourceHandler.handleClientWebsocketChannelTermination((WebSocketFrame)closeWebSocketFrame);
                        return;
                    }
                    RelayUtils.buildMessage((MessageContext)((Axis2MessageContext)msgContext).getAxis2MessageContext(), (boolean)false);
                    TextWebSocketFrame frame2 = new TextWebSocketFrame(this.messageContextToText(((Axis2MessageContext)msgContext).getAxis2MessageContext()));
                    InboundWebsocketChannelContext ctx = this.sourceHandler.getChannelHandlerContext();
                    int clientBroadcastLevel = this.sourceHandler.getClientBroadcastLevel();
                    String subscriberPath = this.sourceHandler.getSubscriberPath();
                    WebsocketSubscriberPathManager pathManager = WebsocketSubscriberPathManager.getInstance();
                    if (this.log.isDebugEnabled()) {
                        WebsocketLogUtil.printWebSocketFrame((Logger)this.log, (WebSocketFrame)frame2, this.sourceHandler.getChannelHandlerContext().getChannelHandlerContext(), false);
                    }
                    this.handleSendBack((WebSocketFrame)frame2, ctx, clientBroadcastLevel, subscriberPath, pathManager);
                }
                catch (IOException ex) {
                    this.log.error((Object)"Failed for format message to specified output format", (Throwable)ex);
                }
                catch (XMLStreamException e) {
                    this.log.error((Object)"Error while building message", (Throwable)e);
                }
            }
        }
    }

    protected void handleSendBack(WebSocketFrame frame, InboundWebsocketChannelContext ctx, int clientBroadcastLevel, String subscriberPath, WebsocketSubscriberPathManager pathManager) {
        if (clientBroadcastLevel == 0) {
            ctx.writeToChannel(frame);
        } else if (clientBroadcastLevel == 1) {
            String endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.sourceHandler.getPort(), this.sourceHandler.getTenantDomain());
            pathManager.broadcastOnSubscriberPath(frame, endpointName, subscriberPath);
        } else if (clientBroadcastLevel == 2) {
            String endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.sourceHandler.getPort(), this.sourceHandler.getTenantDomain());
            pathManager.exclusiveBroadcastOnSubscriberPath(frame, endpointName, subscriberPath, ctx);
        }
    }

    protected String messageContextToText(MessageContext msgCtx) throws IOException {
        OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgCtx);
        MessageFormatter messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgCtx);
        StringWriter sw = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)sw, format.getCharSetEncoding());
        messageFormatter.writeTo(msgCtx, format, (OutputStream)out, true);
        out.close();
        return sw.toString();
    }
}

