/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ODS
extends AbstractSegment {
    public ODS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(159)}, "Type");
            this.add(CWE.class, false, 10, 250, new Object[]{this.getMessage()}, "Service Period");
            this.add(CWE.class, true, 20, 250, new Object[]{this.getMessage()}, "Diet, Supplement, or Preference Code");
            this.add(ST.class, false, 2, 80, new Object[]{this.getMessage()}, "Text Instruction");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ODS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getType() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getOds1_Type() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getServicePeriod() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public CWE[] getOds2_ServicePeriod() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public int getServicePeriodReps() {
        return this.getReps(2);
    }

    public CWE getServicePeriod(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getOds2_ServicePeriod(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getOds2_ServicePeriodReps() {
        return this.getReps(2);
    }

    public CWE insertServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertOds2_ServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeOds2_ServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE[] getDietSupplementOrPreferenceCode() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public CWE[] getOds3_DietSupplementOrPreferenceCode() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public int getDietSupplementOrPreferenceCodeReps() {
        return this.getReps(3);
    }

    public CWE getDietSupplementOrPreferenceCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getOds3_DietSupplementOrPreferenceCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOds3_DietSupplementOrPreferenceCodeReps() {
        return this.getReps(3);
    }

    public CWE insertDietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertOds3_DietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeDietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeOds3_DietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public ST[] getTextInstruction() {
        ST[] retVal = (ST[])this.getTypedField(4, new ST[0]);
        return retVal;
    }

    public ST[] getOds4_TextInstruction() {
        ST[] retVal = (ST[])this.getTypedField(4, new ST[0]);
        return retVal;
    }

    public int getTextInstructionReps() {
        return this.getReps(4);
    }

    public ST getTextInstruction(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public ST getOds4_TextInstruction(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public int getOds4_TextInstructionReps() {
        return this.getReps(4);
    }

    public ST insertTextInstruction(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST insertOds4_TextInstruction(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST removeTextInstruction(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST removeOds4_TextInstruction(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(159));
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

