/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.IS;
import ca.uhn.hl7v2.model.v231.datatype.PL;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NPU
extends AbstractSegment {
    public NPU(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 80, new Object[]{this.getMessage()}, "Bed Location");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(116)}, "Bed Status");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating NPU - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getBedLocation() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getNpu1_BedLocation() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getBedStatus() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getNpu2_BedStatus() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(116));
            }
        }
        return null;
    }
}

