/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CSP
extends AbstractSegment {
    public CSP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Study Phase Identifier");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date/time Study Phase Began");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/time Study Phase Ended");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Study Phase Evaluability");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating CSP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getStudyPhaseIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getCsp1_StudyPhaseIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getDateTimeStudyPhaseBegan() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getCsp2_DateTimeStudyPhaseBegan() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDateTimeStudyPhaseEnded() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getCsp3_DateTimeStudyPhaseEnded() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getStudyPhaseEvaluability() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getCsp4_StudyPhaseEvaluability() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

