/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v22.group.ORU_R01_PATIENT_RESULT;
import ca.uhn.hl7v2.model.v22.segment.DSC;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORU_R01
extends AbstractMessage {
    public ORU_R01() {
        this(new DefaultModelClassFactory());
    }

    public ORU_R01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(ORU_R01_PATIENT_RESULT.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORU_R01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public ORU_R01_PATIENT_RESULT getPATIENT_RESULT() {
        return this.getTyped("PATIENT_RESULT", ORU_R01_PATIENT_RESULT.class);
    }

    public ORU_R01_PATIENT_RESULT getPATIENT_RESULT(int rep) {
        return this.getTyped("PATIENT_RESULT", rep, ORU_R01_PATIENT_RESULT.class);
    }

    public int getPATIENT_RESULTReps() {
        return this.getReps("PATIENT_RESULT");
    }

    public List<ORU_R01_PATIENT_RESULT> getPATIENT_RESULTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_RESULT", ORU_R01_PATIENT_RESULT.class);
    }

    public void insertPATIENT_RESULT(ORU_R01_PATIENT_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_RESULT", structure, rep);
    }

    public ORU_R01_PATIENT_RESULT insertPATIENT_RESULT(int rep) throws HL7Exception {
        return (ORU_R01_PATIENT_RESULT)super.insertRepetition("PATIENT_RESULT", rep);
    }

    public ORU_R01_PATIENT_RESULT removePATIENT_RESULT(int rep) throws HL7Exception {
        return (ORU_R01_PATIENT_RESULT)super.removeRepetition("PATIENT_RESULT", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

