/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v22.group.MFN_M02_MF_STAFF;
import ca.uhn.hl7v2.model.v22.segment.MFI;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M02
extends AbstractMessage {
    public MFN_M02() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M02_MF_STAFF.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MFN_M02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_M02_MF_STAFF getMF_STAFF() {
        return this.getTyped("MF_STAFF", MFN_M02_MF_STAFF.class);
    }

    public MFN_M02_MF_STAFF getMF_STAFF(int rep) {
        return this.getTyped("MF_STAFF", rep, MFN_M02_MF_STAFF.class);
    }

    public int getMF_STAFFReps() {
        return this.getReps("MF_STAFF");
    }

    public List<MFN_M02_MF_STAFF> getMF_STAFFAll() throws HL7Exception {
        return this.getAllAsList("MF_STAFF", MFN_M02_MF_STAFF.class);
    }

    public void insertMF_STAFF(MFN_M02_MF_STAFF structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_STAFF", structure, rep);
    }

    public MFN_M02_MF_STAFF insertMF_STAFF(int rep) throws HL7Exception {
        return (MFN_M02_MF_STAFF)super.insertRepetition("MF_STAFF", rep);
    }

    public MFN_M02_MF_STAFF removeMF_STAFF(int rep) throws HL7Exception {
        return (MFN_M02_MF_STAFF)super.removeRepetition("MF_STAFF", rep);
    }
}

