/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;

public abstract class AbstractType
implements Type {
    private static final long serialVersionUID = -6976260024197429201L;
    private final ExtraComponents extra;
    private final Message message;

    public AbstractType(Message message) {
        this.extra = new ExtraComponents(message);
        this.message = message;
    }

    public String getName() {
        String longClassName = this.getClass().getName();
        return longClassName.substring(longClassName.lastIndexOf(46) + 1);
    }

    public ExtraComponents getExtraComponents() {
        return this.extra;
    }

    public Message getMessage() {
        return this.message;
    }

    public void parse(String string) throws HL7Exception {
        this.clear();
        this.getMessage().getParser().parse(this, string, EncodingCharacters.getInstance(this.getMessage()));
    }

    public String encode() throws HL7Exception {
        return this.getMessage().getParser().doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    public void clear() {
        this.extra.clear();
    }

    public boolean isEmpty() {
        return this.extra.numComponents() > 0;
    }

    public String toString() {
        return AbstractType.toString(this);
    }

    static String toString(Type theType) {
        StringBuilder b = new StringBuilder();
        b.append(theType.getClass().getSimpleName());
        b.append("[");
        b.append(PipeParser.encode(theType, EncodingCharacters.defaultInstance()));
        b.append("]");
        return b.toString();
    }
}

